/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.taskgraph.executor.workflow.latch;

import com.ebay.taskgraph.executor.ApplicationException;
import com.ebay.taskgraph.executor.CallableTaskResultThrowable;
import com.ebay.taskgraph.executor.ICallableTask;
import com.ebay.taskgraph.executor.ICallableTaskFuture;
import com.ebay.taskgraph.executor.Task;
import com.ebay.taskgraph.executor.workflow.latch.SingleCountDownLatch;

public class SingleCountDownLatchTask<T>
extends Task
implements ICallableTask<T> {
    private ICallableTaskFuture<T> task;
    private final SingleCountDownLatch<T> latch;

    public SingleCountDownLatchTask(ICallableTaskFuture<T> task, SingleCountDownLatch<T> latch) {
        super(task.getTask().getName() + "_latch", task.getTask().getTaskConfig(), new ICallableTaskFuture[0]);
        this.task = task;
        this.latch = latch;
    }

    @Override
    public T call() throws Exception {
        T rval = null;
        try {
            rval = this.task.getNoThrow(this);
            if (rval != null) {
                this.latch.countDown(this);
            }
        }
        catch (ApplicationException e) {
            this.task = new CallableTaskResultThrowable(e);
            this.latch.countDown(this);
        }
        return rval;
    }

    public ICallableTaskFuture<T> getTask() {
        return this.task;
    }
}

