/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.taskgraph.service;

import com.ebay.taskgraph.diagnostic.IProfilerEntry;
import com.ebay.taskgraph.executor.ApplicationException;
import com.ebay.taskgraph.executor.ICallableTask;
import com.ebay.taskgraph.executor.Task;
import com.ebay.taskgraph.service.IServiceInvoker;
import com.ebay.taskgraph.service.ServiceInvokerExceptionError;
import java.util.List;
import javax.ws.rs.core.HttpHeaders;

public class ServiceInvokerDiagnosticDecorator<T, S>
implements IServiceInvoker<T, S> {
    private final IServiceInvoker<T, S> client;
    private final boolean logServiceDiagnostic;
    private ICallableTask<?> parentTask;

    public ServiceInvokerDiagnosticDecorator(IServiceInvoker<T, S> client, ICallableTask<?> task, boolean logServiceDiagnostic) {
        this.client = client;
        this.parentTask = task;
        this.logServiceDiagnostic = logServiceDiagnostic;
    }

    public ServiceInvokerDiagnosticDecorator(IServiceInvoker<T, S> client, ICallableTask<?> task) {
        this(client, task, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public S getResponse(T request, HttpHeaders headers) {
        Object response = null;
        IProfilerEntry entry = this.parentTask.getContext().getProfiler().newEntry("getResponse");
        try {
            response = this.client.getResponse(request, headers);
            if (this.logServiceDiagnostic) {
                this.parentTask.getContext().getDiagnostic().addServiceDiagnostic(this.parentTask.getName(), this.client, request, response, headers);
            }
        }
        catch (ApplicationException bae) {
            throw bae;
        }
        catch (Throwable t) {
            Task.logTaskException(this.parentTask, t);
            this.parentTask.getContext().getDiagnostic().addServiceDiagnostic(this.parentTask.getContext().getName(), this.client, request, null, headers);
            this.parentTask.getContext().getError().addError(new ServiceInvokerExceptionError(this.parentTask.getContext().getName(), t));
        }
        finally {
            this.parentTask.getContext().getProfiler().add(entry);
        }
        return (S)response;
    }

    @Override
    public String getRequestHeadersDiagnostic(HttpHeaders headers) {
        return this.client.getRequestHeadersDiagnostic(headers);
    }

    @Override
    public String getRequestDiagnostic(T request) {
        return this.client.getRequestDiagnostic(request);
    }

    @Override
    public String getResponseDiagnostic(S response) {
        return this.client.getResponseDiagnostic(response);
    }

    @Override
    public List<String> convertResponseDiagnostics(S response) {
        return this.client.convertResponseDiagnostics(response);
    }
}

