/*
 * Decompiled with CFR 0.152.
 */
package com.editorbar.sdk;

import com.editorbar.sdk.Config;
import com.editorbar.sdk.Credential;
import com.editorbar.sdk.HttpRequest;
import com.editorbar.sdk.HttpResponse;
import com.editorbar.sdk.RequestBuilder;
import com.editorbar.sdk.exception.SdkException;
import com.editorbar.sdk.util.GsonUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class Client {
    private static String endpoint = "http://127.0.0.1:9998";
    private Credential credential;
    private OkHttpClient conn;

    public Client(Credential credential) {
        this(new Config(), credential);
    }

    public Client(Config config, Credential credential) {
        this.credential = credential;
        this.initHttpClient(config);
    }

    public <T extends HttpResponse> T execute(HttpRequest<T> request) throws IOException {
        Request req = RequestBuilder.build(endpoint, request, this.credential);
        Response response = this.conn.newCall(req).execute();
        if (response.isSuccessful()) {
            String string = response.body().string();
            HttpResponse t = (HttpResponse)GsonUtils.gson.fromJson(string, request.getResponseClass());
            t.setOkResponse(response);
            return (T)t;
        }
        throw new SdkException("http network status code: " + response.code());
    }

    public <T extends HttpResponse> T getResponse(HttpRequest<T> request) throws IOException, IllegalAccessException, InstantiationException {
        Request req = RequestBuilder.build(endpoint, request, this.credential);
        Response response = this.conn.newCall(req).execute();
        if (response.isSuccessful()) {
            HttpResponse t = (HttpResponse)request.getResponseClass().newInstance();
            t.setCode(0);
            t.setOkResponse(response);
            return (T)t;
        }
        throw new SdkException("http network status code: " + response.code());
    }

    private void initHttpClient(Config config) {
        ConnectionPool connectionPool = new ConnectionPool(config.getMaxIdleConnections(), config.getKeepAliveDuration(), TimeUnit.MINUTES);
        this.conn = new OkHttpClient.Builder().connectTimeout((long)config.getConnectTimeout(), TimeUnit.SECONDS).readTimeout((long)config.getReadTimeout(), TimeUnit.SECONDS).writeTimeout((long)config.getWriteTimeout(), TimeUnit.SECONDS).connectionPool(connectionPool).build();
    }
}

