/*
 * Decompiled with CFR 0.152.
 */
package com.editorbar.sdk;

import com.editorbar.sdk.Config;
import com.editorbar.sdk.Credential;
import com.editorbar.sdk.HttpRequest;
import com.editorbar.sdk.HttpResponse;
import com.editorbar.sdk.RequestBuilder;
import com.editorbar.sdk.TrustAllManager;
import com.editorbar.sdk.exception.SdkException;
import com.editorbar.sdk.util.GsonUtils;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class Client {
    private Credential credential;
    private OkHttpClient conn;
    private Config config;

    public Client(Credential credential) {
        this(new Config(), credential);
    }

    public Client(Config config, Credential credential) {
        this.credential = credential;
        this.config = config;
        this.initHttpClient(config);
    }

    public <T extends HttpResponse> T execute(HttpRequest<T> request) throws IOException {
        Request req = RequestBuilder.build(this.config.getEndpoint(), request, this.credential);
        Response response = this.conn.newCall(req).execute();
        if (response.isSuccessful()) {
            String string = response.body().string();
            HttpResponse t = (HttpResponse)GsonUtils.gson.fromJson(string, request.getResponseClass());
            t.setOkResponse(response);
            return (T)t;
        }
        throw new SdkException("http network status code: " + response.code());
    }

    public <T extends HttpResponse> T getResponse(HttpRequest<T> request) throws IOException, IllegalAccessException, InstantiationException {
        Request req = RequestBuilder.build(this.config.getEndpoint(), request, this.credential);
        Response response = this.conn.newCall(req).execute();
        if (response.isSuccessful()) {
            HttpResponse t = (HttpResponse)request.getResponseClass().newInstance();
            t.setCode(0);
            t.setOkResponse(response);
            return (T)t;
        }
        throw new SdkException("http network status code: " + response.code());
    }

    private void initHttpClient(Config config) {
        ConnectionPool connectionPool = new ConnectionPool(config.getMaxIdleConnections(), config.getKeepAliveDuration(), TimeUnit.MINUTES);
        TrustAllManager trustAllManager = new TrustAllManager();
        this.conn = new OkHttpClient.Builder().connectTimeout((long)config.getConnectTimeout(), TimeUnit.SECONDS).readTimeout((long)config.getReadTimeout(), TimeUnit.SECONDS).writeTimeout((long)config.getWriteTimeout(), TimeUnit.SECONDS).connectionPool(connectionPool).sslSocketFactory(this.createTrustAllSSLFactory(trustAllManager), (X509TrustManager)trustAllManager).hostnameVerifier(this.createTrustAllHostnameVerifier()).build();
    }

    private SSLSocketFactory createTrustAllSSLFactory(TrustAllManager trustAllManager) {
        SSLSocketFactory ssfFactory = null;
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{trustAllManager}, new SecureRandom());
            ssfFactory = sc.getSocketFactory();
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
        return ssfFactory;
    }

    private HostnameVerifier createTrustAllHostnameVerifier() {
        return (hostname, session) -> true;
    }
}

