/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapers.api.restapi;

import com.elastisys.scale.cloudadapers.api.CloudAdapter;
import com.elastisys.scale.commons.rest.types.ErrorType;
import com.google.common.base.Optional;
import com.google.gson.JsonObject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/config")
public class ConfigHandler {
    static Logger log = LoggerFactory.getLogger(ConfigHandler.class);
    private final CloudAdapter cloudAdapter;

    public ConfigHandler(CloudAdapter cloudAdapter) {
        log.info(this.getClass().getSimpleName() + " created");
        this.cloudAdapter = cloudAdapter;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getConfig() {
        log.info("GET /config");
        try {
            Optional<JsonObject> configuration = this.cloudAdapter.getConfiguration();
            if (!configuration.isPresent()) {
                ErrorType entity = new ErrorType("no cloud adapter configuration has been set");
                return Response.status(Response.Status.NOT_FOUND).entity(entity).build();
            }
            return Response.ok(configuration.get()).build();
        }
        catch (Exception e) {
            String message = "failure to process config get request: " + e.getMessage();
            log.error(message, e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(new ErrorType(message, e)).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setConfig(JsonObject configuration) {
        log.info("POST /config");
        try {
            this.cloudAdapter.configure(configuration);
            return Response.ok().build();
        }
        catch (IllegalArgumentException e) {
            String message = "illegal input: " + e.getMessage();
            log.error(message, e);
            return Response.status(Response.Status.BAD_REQUEST).entity(new ErrorType(message, e)).build();
        }
        catch (Exception e) {
            String message = "failure to process config set request: " + e.getMessage();
            log.error(message, e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(new ErrorType(message, e)).build();
        }
    }
}

