/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapers.api.restapi;

import com.elastisys.scale.cloudadapers.api.CloudAdapter;
import com.elastisys.scale.commons.rest.types.ErrorType;
import com.google.common.base.Optional;
import com.google.gson.JsonObject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/config/schema")
public class ConfigSchemaHandler {
    static Logger log = LoggerFactory.getLogger(ConfigSchemaHandler.class);
    private final CloudAdapter cloudAdapter;

    public ConfigSchemaHandler(CloudAdapter cloudAdapter) {
        log.info(this.getClass().getSimpleName() + " created");
        this.cloudAdapter = cloudAdapter;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getConfigurationSchema() {
        log.info("GET /config/schema");
        try {
            Optional<JsonObject> schema = this.cloudAdapter.getConfigurationSchema();
            if (!schema.isPresent()) {
                ErrorType entity = new ErrorType("cloud adapter does not publish a configuration schema");
                return Response.status(Response.Status.NOT_FOUND).entity(entity).build();
            }
            return Response.ok(schema.get()).build();
        }
        catch (Exception e) {
            String message = "failure to process config schema get request: " + e.getMessage();
            log.error(message, e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(new ErrorType(message, e)).build();
        }
    }
}

