/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapers.api.restapi;

import com.elastisys.scale.cloudadapers.api.CloudAdapter;
import com.elastisys.scale.cloudadapers.api.NotFoundException;
import com.elastisys.scale.cloudadapers.api.restapi.types.DetachMachineRequest;
import com.elastisys.scale.cloudadapers.api.restapi.types.SetDesiredSizeRequest;
import com.elastisys.scale.cloudadapers.api.restapi.types.SetServiceStateRequest;
import com.elastisys.scale.cloudadapers.api.restapi.types.TerminateMachineRequest;
import com.elastisys.scale.cloudadapers.api.types.MachinePool;
import com.elastisys.scale.cloudadapers.api.types.PoolSizeSummary;
import com.elastisys.scale.commons.json.JsonUtils;
import com.elastisys.scale.commons.rest.types.ErrorType;
import com.google.gson.JsonObject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class PoolHandler {
    static Logger log = LoggerFactory.getLogger(PoolHandler.class);
    private final CloudAdapter cloudAdapter;

    public PoolHandler(CloudAdapter cloudAdapter) {
        log.info(this.getClass().getSimpleName() + " created");
        this.cloudAdapter = cloudAdapter;
    }

    @GET
    @Path(value="/pool")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getPool() {
        log.info("GET /pool");
        try {
            MachinePool machinePool = this.cloudAdapter.getMachinePool();
            return Response.ok(this.toJson(machinePool)).build();
        }
        catch (Exception e) {
            String message = "failure to process pool GET /pool: " + e.getMessage();
            log.error(message, e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(new ErrorType(message, e)).build();
        }
    }

    @POST
    @Path(value="/pool/size")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setDesiredSize(SetDesiredSizeRequest request) {
        log.info("POST /pool/size");
        try {
            this.cloudAdapter.setDesiredSize(request.getDesiredSize());
            return Response.ok().build();
        }
        catch (IllegalArgumentException e) {
            String message = "illegal input: " + e.getMessage();
            return Response.status(Response.Status.BAD_REQUEST).entity(new ErrorType(message, e)).build();
        }
        catch (Exception e) {
            String message = "failure to process POST /pool/size: " + e.getMessage();
            log.error(message, e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(new ErrorType(message, e)).build();
        }
    }

    @GET
    @Path(value="/pool/size")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getPoolSize() {
        log.info("GET /pool/size");
        try {
            PoolSizeSummary poolSize = this.cloudAdapter.getPoolSize();
            return Response.ok(this.toJson(poolSize)).build();
        }
        catch (Exception e) {
            String message = "failure to process GET /pool/size: " + e.getMessage();
            log.error(message, e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(new ErrorType(message, e)).build();
        }
    }

    @POST
    @Path(value="/pool/{machine}/terminate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response terminateMachine(@PathParam(value="machine") String machineId, TerminateMachineRequest request) {
        log.info("POST /pool/{}/terminate", (Object)machineId);
        try {
            this.cloudAdapter.terminateMachine(machineId, request.isDecrementDesiredSize());
            return Response.ok().build();
        }
        catch (NotFoundException e) {
            String message = "unrecognized machine: " + e.getMessage();
            return Response.status(Response.Status.NOT_FOUND).entity(new ErrorType(message, e)).build();
        }
        catch (Exception e) {
            String message = String.format("failure to process POST /pool/%s/terminate: %s", machineId, e.getMessage());
            log.error(message, e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(new ErrorType(message, e)).build();
        }
    }

    @POST
    @Path(value="/pool/{machine}/detach")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response detachMachine(@PathParam(value="machine") String machineId, DetachMachineRequest request) {
        log.info("POST /pool/{}/detach", (Object)machineId);
        try {
            this.cloudAdapter.detachMachine(machineId, request.isDecrementDesiredSize());
            return Response.ok().build();
        }
        catch (NotFoundException e) {
            String message = "unrecognized machine: " + e.getMessage();
            return Response.status(Response.Status.NOT_FOUND).entity(new ErrorType(message, e)).build();
        }
        catch (Exception e) {
            String message = String.format("failure to process POST /pool/%s/detach: %s", machineId, e.getMessage());
            log.error(message, e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(new ErrorType(message, e)).build();
        }
    }

    @POST
    @Path(value="/pool/{machine}/attach")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response attachMachine(@PathParam(value="machine") String machineId) {
        log.info("POST /pool/{}/attach", (Object)machineId);
        try {
            this.cloudAdapter.attachMachine(machineId);
            return Response.ok().build();
        }
        catch (NotFoundException e) {
            String message = "unrecognized machine: " + e.getMessage();
            return Response.status(Response.Status.NOT_FOUND).entity(new ErrorType(message, e)).build();
        }
        catch (Exception e) {
            String message = String.format("failure to process POST /pool/%s/attach: %s", machineId, e.getMessage());
            log.error(message, e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(new ErrorType(message, e)).build();
        }
    }

    @POST
    @Path(value="/pool/{machine}/serviceState")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setServiceState(@PathParam(value="machine") String machineId, SetServiceStateRequest request) {
        log.info("POST /pool/{}/serviceState", (Object)machineId);
        try {
            this.cloudAdapter.setServiceState(machineId, request.getServiceState());
            return Response.ok().build();
        }
        catch (NotFoundException e) {
            String message = "unrecognized machine: " + e.getMessage();
            return Response.status(Response.Status.NOT_FOUND).entity(new ErrorType(message, e)).build();
        }
        catch (Exception e) {
            String message = String.format("failure to process POST /pool/%s/serviceState: %s", machineId, e.getMessage());
            log.error(message, e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(new ErrorType(message, e)).build();
        }
    }

    private JsonObject toJson(Object object) {
        return JsonUtils.toJson(object).getAsJsonObject();
    }
}

