/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapers.api.server;

import com.elastisys.scale.cloudadapers.api.CloudAdapter;
import com.elastisys.scale.cloudadapers.api.restapi.ConfigHandler;
import com.elastisys.scale.cloudadapers.api.restapi.ConfigSchemaHandler;
import com.elastisys.scale.cloudadapers.api.restapi.PoolHandler;
import com.elastisys.scale.cloudadapers.api.server.CloudAdapterOptions;
import com.elastisys.scale.commons.json.JsonUtils;
import com.elastisys.scale.commons.rest.responsehandlers.ExitHandler;
import com.elastisys.scale.commons.rest.server.JaxRsApplication;
import com.elastisys.scale.commons.server.ServletDefinition;
import com.elastisys.scale.commons.server.ServletServerBuilder;
import com.elastisys.scale.commons.server.SslKeyStoreType;
import com.elastisys.scale.commons.util.io.IoUtils;
import com.google.common.base.Charsets;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import org.eclipse.jetty.server.Server;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ParserProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudAdapterServer {
    static Logger log = LoggerFactory.getLogger(CloudAdapterServer.class);

    public static void main(CloudAdapter cloudAdapter, String[] args) throws Exception {
        CloudAdapterOptions arguments = new CloudAdapterOptions();
        ParserProperties parserConfig = ParserProperties.defaults().withUsageWidth(80);
        CmdLineParser parser = new CmdLineParser(arguments, parserConfig);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            log.error("error: " + e.getMessage());
            parser.printUsage(System.err);
            System.exit(-1);
        }
        if (arguments.help) {
            parser.printUsage(System.err);
            System.exit(0);
        }
        if (arguments.version) {
            System.err.println(IoUtils.toString("VERSION.txt", Charsets.UTF_8));
            System.exit(0);
        }
        Server server = CloudAdapterServer.createServer(cloudAdapter, arguments);
        log.info("Starting Jetty server with HTTPS port " + arguments.httpsPort);
        try {
            server.start();
        }
        catch (Exception e) {
            log.error("failed to start server: " + e.getMessage(), e);
            System.exit(-1);
        }
        log.info("Started Jetty server with HTTPS port " + arguments.httpsPort);
        server.join();
    }

    public static Server createServer(CloudAdapter cloudAdapter, CloudAdapterOptions options) throws Exception {
        JaxRsApplication application = new JaxRsApplication(new Object[0]);
        application.addHandler(new PoolHandler(cloudAdapter));
        if (options.enableConfigHandler) {
            application.addHandler(new ConfigHandler(cloudAdapter));
            application.addHandler(new ConfigSchemaHandler(cloudAdapter));
        }
        if (options.enableExitHandler) {
            application.addHandler(new ExitHandler());
        }
        if (options.config != null) {
            JsonObject configuration = CloudAdapterServer.parseJsonConfig(options.config);
            cloudAdapter.configure(configuration);
        }
        ServletContainer restApiServlet = new ServletContainer(ResourceConfig.forApplication(application));
        ServletDefinition servlet = new ServletDefinition.Builder().servlet(restApiServlet).build();
        Server server = ServletServerBuilder.create().httpsPort(options.httpsPort).sslKeyStoreType(SslKeyStoreType.PKCS12).sslKeyStorePath(options.sslKeyStore).sslKeyStorePassword(options.sslKeyStorePassword).sslTrustStoreType(SslKeyStoreType.JKS).sslTrustStorePath(options.sslTrustStore).sslTrustStorePassword(options.sslTrustStorePassword).sslRequireClientCert(options.requireClientCert).addServlet(servlet).build();
        return server;
    }

    private static JsonObject parseJsonConfig(String configFile) throws IOException {
        JsonObject configuration;
        try {
            configuration = JsonUtils.parseJsonFile(new File(configFile));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to parse JSON configuration file: " + e.getMessage(), e);
        }
        return configuration;
    }
}

