/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapers.api.types;

import com.elastisys.scale.cloudadapers.api.types.MachineState;
import com.elastisys.scale.cloudadapers.api.types.ServiceState;
import com.elastisys.scale.commons.util.time.UtcTime;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;

public class Machine {
    private final String id;
    private MachineState machineState;
    private ServiceState serviceState;
    private final DateTime launchtime;
    private final List<String> publicIps;
    private final List<String> privateIps;
    private final JsonObject metadata;

    public Machine(String id, MachineState state, DateTime launchtime, List<String> publicIps, List<String> privateIps) {
        this(id, state, ServiceState.UNKNOWN, launchtime, publicIps, privateIps, null);
    }

    public Machine(String id, MachineState machineState, ServiceState serviceState, DateTime launchtime, List<String> publicIps, List<String> privateIps) {
        this(id, machineState, serviceState, launchtime, publicIps, privateIps, null);
    }

    public Machine(String id, MachineState machineState, ServiceState serviceState, DateTime launchtime, List<String> publicIps, List<String> privateIps, JsonObject metadata) {
        Preconditions.checkNotNull(id, "missing id");
        Preconditions.checkNotNull(machineState, "missing machineState");
        Preconditions.checkNotNull(serviceState, "missing serviceState");
        this.id = id;
        this.machineState = machineState;
        this.serviceState = serviceState;
        this.launchtime = launchtime;
        this.publicIps = Optional.fromNullable(publicIps).or(new ArrayList());
        this.privateIps = Optional.fromNullable(privateIps).or(new ArrayList());
        this.metadata = metadata;
    }

    public String getId() {
        return this.id;
    }

    public MachineState getMachineState() {
        return this.machineState;
    }

    public void setMachineState(MachineState state) {
        this.machineState = state;
    }

    public ServiceState getServiceState() {
        return this.serviceState;
    }

    public void setServiceState(ServiceState serviceState) {
        this.serviceState = serviceState;
    }

    public DateTime getLaunchtime() {
        return this.launchtime;
    }

    public List<String> getPublicIps() {
        return this.publicIps;
    }

    public List<String> getPrivateIps() {
        return this.privateIps;
    }

    public JsonObject getMetadata() {
        return this.metadata;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.machineState, this.serviceState, this.launchtime, this.publicIps, this.privateIps, this.metadata});
    }

    public boolean equals(Object obj) {
        if (obj instanceof Machine) {
            Machine that = (Machine)obj;
            boolean launchtimesEqual = this.launchtime != null && that.launchtime != null ? this.launchtime.isEqual(that.launchtime) : this.launchtime == null && that.launchtime == null;
            return Objects.equal(this.id, that.id) && Objects.equal((Object)this.machineState, (Object)that.machineState) && Objects.equal((Object)this.serviceState, (Object)that.serviceState) && launchtimesEqual && Objects.equal(this.publicIps, that.publicIps) && Objects.equal(this.privateIps, that.privateIps) && Objects.equal(this.metadata, that.metadata);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("machineState", (Object)this.machineState).add("serviceState", (Object)this.serviceState).add("launchtime", this.launchtime).add("publicIps", this.publicIps).add("privateIps", this.privateIps).add("metadata", this.metadata).toString();
    }

    public static Function<? super Machine, MachineState> toState() {
        return new MachineStateExtractor();
    }

    public static Function<? super Machine, String> toId() {
        return new MachineIdExtractor();
    }

    public static Function<? super Machine, Long> remainingInstanceHourTime() {
        return new RemainingInstanceHourTime();
    }

    public static Function<? super Machine, DateTime> instanceHourStart() {
        return new InstanceHourStart();
    }

    public static Predicate<? super Machine> withState(MachineState state) {
        return new MachineWithState(state);
    }

    public static Predicate<? super Machine> withServiceState(ServiceState serviceState) {
        return new MachineWithServiceState(serviceState);
    }

    public static Predicate<? super Machine> isEffectiveMember() {
        return new EffectiveMemberPredicate();
    }

    public static Predicate<? super Machine> isAllocated() {
        return new AllocatedMachinePredicate();
    }

    public static Predicate<? super Machine> isActive() {
        return new MachineActivePredicate();
    }

    public static List<Machine> sort(Collection<Machine> machines, Comparator<Machine> comparator) {
        ArrayList<Machine> list = Lists.newArrayList(machines);
        Collections.sort(list, comparator);
        return list;
    }

    public static Function<Machine, String> toShortFormat() {
        return new ToShortMachineFormat();
    }

    public static class ToShortMachineFormat
    implements Function<Machine, String> {
        @Override
        public String apply(Machine input) {
            return MoreObjects.toStringHelper("Machine").add("id", input.getId()).add("machineState", input.getMachineState().name()).add("serviceState", input.getServiceState().name()).add("launchtime", input.getLaunchtime()).add("publicIps", input.getPublicIps()).add("privateIps", input.getPrivateIps()).toString();
        }
    }

    public static class RemainingInstanceHourTime
    implements Function<Machine, Long> {
        @Override
        public Long apply(Machine machine) {
            Preconditions.checkArgument(machine != null, "null machine");
            Preconditions.checkArgument(machine.getLaunchtime() != null, "null launch time for machine");
            DateTime HourStart = Machine.instanceHourStart().apply(machine);
            DateTime nextHourStart = HourStart.plusHours(1);
            long millisToNextHour = nextHourStart.getMillis() - UtcTime.now().getMillis();
            return millisToNextHour / 1000L;
        }
    }

    public static class InstanceHourStart
    implements Function<Machine, DateTime> {
        @Override
        public DateTime apply(Machine machine) {
            Preconditions.checkArgument(machine != null, "null machine");
            Preconditions.checkArgument(machine.getLaunchtime() != null, "null launch time for machine");
            DateTime now = UtcTime.now();
            DateTime launchtime = machine.getLaunchtime();
            long secondsPerHour = TimeUnit.SECONDS.convert(1L, TimeUnit.HOURS);
            long millisPerSecond = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.SECONDS);
            long millisPerHour = secondsPerHour * millisPerSecond;
            long epochMillis = launchtime.getMillis();
            long wallclockhourOffset = epochMillis % millisPerHour;
            DateTime currentHour = now.withMinuteOfHour(0).withSecondOfMinute(0).withMillisOfSecond(0);
            DateTime HourStart = currentHour.plus(wallclockhourOffset);
            if (now.isBefore(HourStart)) {
                HourStart = HourStart.minusHours(1);
            }
            return HourStart;
        }
    }

    public static class MachineActivePredicate
    implements Predicate<Machine> {
        private static final Set<MachineState> activeStates = Sets.newHashSet(MachineState.PENDING, MachineState.RUNNING);

        @Override
        public boolean apply(Machine machine) {
            return machine.getLaunchtime() != null && activeStates.contains((Object)machine.getMachineState()) && machine.getServiceState() != ServiceState.OUT_OF_SERVICE;
        }
    }

    public static class AllocatedMachinePredicate
    implements Predicate<Machine> {
        private static final Set<MachineState> allocatedStates = Sets.newHashSet(MachineState.REQUESTED, MachineState.PENDING, MachineState.RUNNING);

        @Override
        public boolean apply(Machine machine) {
            return allocatedStates.contains((Object)machine.getMachineState());
        }
    }

    public static class EffectiveMemberPredicate
    implements Predicate<Machine> {
        private static final Set<MachineState> allocatedStates = Sets.newHashSet(MachineState.REQUESTED, MachineState.PENDING, MachineState.RUNNING);

        @Override
        public boolean apply(Machine machine) {
            return allocatedStates.contains((Object)machine.getMachineState()) && machine.getServiceState() != ServiceState.OUT_OF_SERVICE;
        }
    }

    public static class MachineIdExtractor
    implements Function<Machine, String> {
        @Override
        public String apply(Machine machine) {
            return machine.getId();
        }
    }

    public static class MachineStateExtractor
    implements Function<Machine, MachineState> {
        @Override
        public MachineState apply(Machine machine) {
            return machine.getMachineState();
        }
    }

    public static class MachineWithServiceState
    implements Predicate<Machine> {
        private final ServiceState serviceState;

        public MachineWithServiceState(ServiceState serviceState) {
            Preconditions.checkNotNull(serviceState);
            this.serviceState = serviceState;
        }

        @Override
        public boolean apply(Machine machine) {
            return machine.getServiceState() == this.serviceState;
        }
    }

    public static class MachineWithState
    implements Predicate<Machine> {
        private final MachineState state;

        public MachineWithState(MachineState state) {
            Preconditions.checkNotNull(state);
            this.state = state;
        }

        @Override
        public boolean apply(Machine machine) {
            return machine.getMachineState() == this.state;
        }
    }
}

