/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapers.api.types;

import com.elastisys.scale.cloudadapers.api.types.Machine;
import com.elastisys.scale.cloudadapers.api.types.ServiceState;
import com.elastisys.scale.commons.json.JsonUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

public class MachinePool {
    private final List<Machine> machines;
    private final DateTime timestamp;

    public MachinePool(List<? extends Machine> machines, DateTime timestamp) {
        Preconditions.checkNotNull(machines, "machines cannot be null");
        Preconditions.checkNotNull(timestamp, "timestamp cannot be null");
        this.machines = Lists.newArrayList(machines);
        this.timestamp = timestamp;
    }

    public List<Machine> getMachines() {
        return ImmutableList.copyOf(this.machines);
    }

    public List<Machine> getOutOfServiceMachines() {
        Iterable<? super Machine> outOfServiceMachines = Iterables.filter(this.getAllocatedMachines(), Machine.withServiceState(ServiceState.OUT_OF_SERVICE));
        return Lists.newArrayList(outOfServiceMachines);
    }

    public List<Machine> getEffectiveMachines() {
        Iterable<? super Machine> effectiveMachines = Iterables.filter(this.getMachines(), Machine.isEffectiveMember());
        return Lists.newArrayList(effectiveMachines);
    }

    public List<Machine> getAllocatedMachines() {
        Iterable<? super Machine> allocatedMachines = Iterables.filter(this.getMachines(), Machine.isAllocated());
        return Lists.newArrayList(allocatedMachines);
    }

    public List<Machine> getActiveMachines() {
        Iterable<? super Machine> activeMachines = Iterables.filter(this.getMachines(), Machine.isActive());
        return Lists.newArrayList(activeMachines);
    }

    public DateTime getTimestamp() {
        return this.timestamp;
    }

    public static MachinePool emptyPool(DateTime timestamp) {
        return new MachinePool(new ArrayList(), timestamp);
    }

    public int hashCode() {
        return Objects.hashCode(this.timestamp, this.machines);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MachinePool) {
            MachinePool that = (MachinePool)obj;
            boolean timestampsEqual = this.timestamp != null && that.timestamp != null ? this.timestamp.isEqual(that.timestamp) : this.timestamp == null && that.timestamp == null;
            return timestampsEqual && Objects.equal(this.machines, that.machines);
        }
        return false;
    }

    public String toString() {
        List<String> shortPool = Lists.transform(this.machines, Machine.toShortFormat());
        return MoreObjects.toStringHelper(this).add("timestamp", this.timestamp).add("machines", shortPool).toString();
    }

    public static MachinePool fromJson(String machinePoolAsJson) throws IOException {
        MachinePool machinePool = JsonUtils.toObject(JsonUtils.parseJsonString(machinePoolAsJson), MachinePool.class);
        Preconditions.checkNotNull(machinePool.timestamp, "machine pool missing timestamp");
        Preconditions.checkNotNull(machinePool.machines, "machine pool missing instances");
        for (Machine machine : machinePool.machines) {
            Preconditions.checkNotNull(machine.getId(), "machine missing id");
            Preconditions.checkNotNull(machine.getMachineState(), "machine missing state");
        }
        return machinePool;
    }

    public JsonObject toJson() {
        return JsonUtils.toJson(this).getAsJsonObject();
    }
}

