/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapers.api.types;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class PoolSizeSummary {
    private final int desiredSize;
    private final int allocated;
    private final int outOfService;

    public PoolSizeSummary(int desiredSize, int allocated, int outOfService) {
        Preconditions.checkArgument(desiredSize >= 0, "desiredSize must be >= 0");
        Preconditions.checkArgument(allocated >= 0, "allocated must be >= 0");
        Preconditions.checkArgument(outOfService >= 0, "outOfService must be >= 0");
        Preconditions.checkArgument(allocated >= outOfService, "outOfService cannot be greater than allocated");
        this.desiredSize = desiredSize;
        this.allocated = allocated;
        this.outOfService = outOfService;
    }

    public int getDesiredSize() {
        return this.desiredSize;
    }

    public int getAllocated() {
        return this.allocated;
    }

    public int getOutOfService() {
        return this.outOfService;
    }

    public int hashCode() {
        return Objects.hashCode(this.desiredSize, this.allocated, this.outOfService);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PoolSizeSummary) {
            PoolSizeSummary that = (PoolSizeSummary)obj;
            return Objects.equal(this.desiredSize, that.desiredSize) && Objects.equal(this.allocated, that.allocated) && Objects.equal(this.outOfService, that.outOfService);
        }
        return super.equals(obj);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("desiredSize", this.desiredSize).add("allocated", this.allocated).add("outOfService", this.outOfService).toString();
    }
}

