/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.commons.adapter;

import com.elastisys.scale.cloudadapers.api.CloudAdapter;
import com.elastisys.scale.cloudadapers.api.CloudAdapterException;
import com.elastisys.scale.cloudadapers.api.types.Machine;
import com.elastisys.scale.cloudadapers.api.types.MachinePool;
import com.elastisys.scale.cloudadapers.api.types.PoolSizeSummary;
import com.elastisys.scale.cloudadapers.api.types.ServiceState;
import com.elastisys.scale.cloudadapters.commons.adapter.BaseCloudAdapterConfig;
import com.elastisys.scale.cloudadapters.commons.adapter.alerts.AlertTopics;
import com.elastisys.scale.cloudadapters.commons.adapter.scalinggroup.ScalingGroup;
import com.elastisys.scale.cloudadapters.commons.adapter.scalinggroup.StartMachinesException;
import com.elastisys.scale.cloudadapters.commons.resizeplanner.ResizePlan;
import com.elastisys.scale.cloudadapters.commons.resizeplanner.ResizePlanner;
import com.elastisys.scale.cloudadapters.commons.termqueue.ScheduledTermination;
import com.elastisys.scale.cloudadapters.commons.termqueue.TerminationQueue;
import com.elastisys.scale.commons.json.JsonUtils;
import com.elastisys.scale.commons.json.schema.JsonValidator;
import com.elastisys.scale.commons.net.host.HostUtils;
import com.elastisys.scale.commons.net.smtp.SmtpServerSettings;
import com.elastisys.scale.commons.net.smtp.alerter.Alert;
import com.elastisys.scale.commons.net.smtp.alerter.AlertSeverity;
import com.elastisys.scale.commons.net.smtp.alerter.EmailAlerter;
import com.elastisys.scale.commons.net.smtp.alerter.SendSettings;
import com.elastisys.scale.commons.util.time.UtcTime;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.Atomics;
import com.google.gson.JsonObject;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseCloudAdapter
implements CloudAdapter {
    static final Logger LOG = LoggerFactory.getLogger(BaseCloudAdapter.class);
    private static final int MAX_CONCURRENCY = 20;
    private ScalingGroup scalingGroup = null;
    private final JsonObject jsonSchema;
    private final AtomicReference<BaseCloudAdapterConfig> config;
    private final ScheduledExecutorService executorService;
    private final AtomicBoolean started;
    private final AtomicReference<Integer> desiredSize;
    private final EventBus eventBus;
    private final AtomicReference<EmailAlerter> smtpAlerter;
    private ScheduledFuture<?> poolUpdateTask;
    private final Object updateLock = new Object();
    private final TerminationQueue terminationQueue;

    public BaseCloudAdapter(ScalingGroup scalingGroup) {
        this(scalingGroup, new EventBus());
    }

    public BaseCloudAdapter(ScalingGroup scalingGroup, EventBus eventBus) {
        Preconditions.checkArgument(scalingGroup != null, "scalingGroup is null");
        Preconditions.checkArgument(eventBus != null, "eventBus is null");
        this.scalingGroup = scalingGroup;
        this.eventBus = eventBus;
        this.jsonSchema = JsonUtils.parseJsonResource("baseadapter-schema.json");
        this.executorService = Executors.newScheduledThreadPool(20);
        this.config = Atomics.newReference();
        this.started = new AtomicBoolean(false);
        this.smtpAlerter = Atomics.newReference();
        this.terminationQueue = new TerminationQueue();
        this.desiredSize = Atomics.newReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(JsonObject jsonConfig) throws CloudAdapterException {
        BaseCloudAdapterConfig configuration = this.validate(jsonConfig);
        Object object = this.updateLock;
        synchronized (object) {
            this.config.set(configuration);
            if (this.isStarted()) {
                this.stop();
            }
            this.start();
        }
    }

    private BaseCloudAdapterConfig validate(JsonObject jsonConfig) throws CloudAdapterException {
        try {
            JsonValidator.validate(this.jsonSchema, jsonConfig);
            BaseCloudAdapterConfig configuration = JsonUtils.toObject(jsonConfig, BaseCloudAdapterConfig.class);
            configuration.validate();
            return configuration;
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf(e, CloudAdapterException.class);
            throw new CloudAdapterException("failed to validate cloud adapter configuration: " + e.getMessage(), e);
        }
    }

    @Override
    public Optional<JsonObject> getConfigurationSchema() {
        return Optional.of(this.jsonSchema);
    }

    @Override
    public Optional<JsonObject> getConfiguration() {
        BaseCloudAdapterConfig currentConfig = this.config.get();
        if (currentConfig == null) {
            return Optional.absent();
        }
        return Optional.of(JsonUtils.toJson(currentConfig).getAsJsonObject());
    }

    private void start() throws CloudAdapterException {
        Preconditions.checkState(this.getConfiguration().isPresent(), "attempt to start cloud adapter before being configured");
        if (this.isStarted()) {
            return;
        }
        LOG.info("starting {} driving a {}", (Object)this.getClass().getSimpleName(), (Object)this.scalingGroup.getClass().getSimpleName());
        LOG.info("configuring scaling group '{}'", (Object)this.config().getScalingGroup().getName());
        this.scalingGroup.configure(this.config());
        this.determineDesiredSizeIfUnset();
        int poolUpdatePeriod = this.config().getPoolUpdatePeriod();
        this.poolUpdateTask = this.executorService.scheduleWithFixedDelay(new PoolUpdateTask(), poolUpdatePeriod, poolUpdatePeriod, TimeUnit.SECONDS);
        this.setUpSmtpAlerter(this.config());
        this.started.set(true);
        LOG.info(this.getClass().getSimpleName() + " started.");
    }

    private void determineDesiredSizeIfUnset() {
        if (this.desiredSize.get() != null) {
            return;
        }
        try {
            LOG.debug("determining initial desired scaling group size");
            this.setDesiredSizeIfUnset(this.getMachinePool());
        }
        catch (CloudAdapterException e) {
            String message = String.format("failed to determine initial size of scaling group: %s\n%s", e.getMessage(), Throwables.getStackTraceAsString(e));
            this.eventBus.post(new Alert(AlertTopics.POOL_FETCH.name(), AlertSeverity.ERROR, UtcTime.now(), message));
            LOG.error(message);
        }
    }

    private void setDesiredSizeIfUnset(MachinePool pool) {
        if (this.desiredSize.get() != null) {
            return;
        }
        int effectiveSize = pool.getEffectiveMachines().size();
        int allocated = pool.getAllocatedMachines().size();
        int outOfService = pool.getOutOfServiceMachines().size();
        this.desiredSize.set(effectiveSize);
        LOG.info("initial desiredSize is {} (allocated: {}, outOfService: {})", this.desiredSize, allocated, outOfService);
    }

    private void stop() {
        if (this.isStarted()) {
            LOG.debug("stopping {} ...", (Object)this.getClass().getSimpleName());
            this.poolUpdateTask.cancel(false);
            this.poolUpdateTask = null;
            this.takeDownSmtpAlerter();
            this.started.set(false);
        }
        LOG.info(this.getClass().getSimpleName() + " stopped.");
    }

    boolean isStarted() {
        return this.started.get();
    }

    @Override
    public MachinePool getMachinePool() throws CloudAdapterException {
        Preconditions.checkState(this.getConfiguration().isPresent(), "cloud adapter needs to be configured before use");
        List<Machine> machines = this.listMachines();
        MachinePool pool = new MachinePool(machines, UtcTime.now());
        this.setDesiredSizeIfUnset(pool);
        return pool;
    }

    Integer desiredSize() {
        return this.desiredSize.get();
    }

    @Override
    public PoolSizeSummary getPoolSize() throws CloudAdapterException {
        Preconditions.checkState(this.getConfiguration().isPresent(), "cloud adapter needs to be configured before use");
        MachinePool pool = this.getMachinePool();
        return new PoolSizeSummary(this.desiredSize.get(), pool.getAllocatedMachines().size(), pool.getOutOfServiceMachines().size());
    }

    private List<Machine> listMachines() {
        return this.scalingGroup.listMachines();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDesiredSize(int desiredSize) throws IllegalArgumentException, CloudAdapterException {
        Preconditions.checkState(this.getConfiguration().isPresent(), "cloud adapter needs to be configured before use");
        Preconditions.checkArgument(desiredSize >= 0, "negative desired pool size");
        Object object = this.updateLock;
        synchronized (object) {
            LOG.info("set desiredSize to {}", (Object)desiredSize);
            this.desiredSize.set(desiredSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminateMachine(String machineId, boolean decrementDesiredSize) throws IllegalArgumentException, CloudAdapterException {
        Preconditions.checkState(this.getConfiguration().isPresent(), "cloud adapter needs to be configured before use");
        Object object = this.updateLock;
        synchronized (object) {
            LOG.debug("terminating {}", (Object)machineId);
            this.scalingGroup.terminateMachine(machineId);
            if (decrementDesiredSize) {
                int newSize = Math.max(this.desiredSize.get() - 1, 0);
                LOG.debug("decrementing desiredSize to {}", (Object)newSize);
                this.setDesiredSize(newSize);
            }
        }
        this.terminationAlert(machineId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachMachine(String machineId) throws IllegalArgumentException, CloudAdapterException {
        Preconditions.checkState(this.getConfiguration().isPresent(), "cloud adapter needs to be configured before use");
        Object object = this.updateLock;
        synchronized (object) {
            LOG.debug("attaching instance {} to group", (Object)machineId);
            this.scalingGroup.attachMachine(machineId);
            this.setDesiredSize(this.desiredSize.get() + 1);
        }
        this.attachAlert(machineId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachMachine(String machineId, boolean decrementDesiredSize) throws IllegalArgumentException, CloudAdapterException {
        Preconditions.checkState(this.getConfiguration().isPresent(), "cloud adapter needs to be configured before use");
        Object object = this.updateLock;
        synchronized (object) {
            LOG.debug("detaching {} from group", (Object)machineId);
            this.scalingGroup.detachMachine(machineId);
            if (decrementDesiredSize) {
                int newSize = Math.max(this.desiredSize.get() - 1, 0);
                LOG.debug("decrementing desiredSize to {}", (Object)newSize);
                this.setDesiredSize(newSize);
            }
        }
        this.detachAlert(machineId);
    }

    @Override
    public void setServiceState(String machineId, ServiceState serviceState) throws IllegalArgumentException {
        Preconditions.checkState(this.getConfiguration().isPresent(), "cloud adapter needs to be configured before use");
        LOG.debug("service state {} assigned to {}", (Object)serviceState.name(), (Object)machineId);
        this.scalingGroup.setServiceState(machineId, serviceState);
        this.serviceStateAlert(machineId, serviceState);
    }

    private void setUpSmtpAlerter(BaseCloudAdapterConfig configuration) {
        BaseCloudAdapterConfig.AlertSettings alertsConfig = configuration.getAlerts();
        if (alertsConfig != null) {
            LOG.debug("configuring SMTP alerter.");
            SendSettings sendSettings = new SendSettings(alertsConfig.getRecipients(), alertsConfig.getSender(), alertsConfig.getSubject(), alertsConfig.getSeverityFilter());
            SmtpServerSettings mailServerSettings = alertsConfig.getMailServer().toSmtpServerSettings();
            this.smtpAlerter.set(new EmailAlerter(mailServerSettings, sendSettings, this.standardAlertTags()));
            this.eventBus.register(this.smtpAlerter.get());
        }
    }

    private Map<String, String> standardAlertTags() {
        HashMap<String, String> standardTags = Maps.newHashMap();
        ArrayList<String> ipv4Addresses = Lists.newArrayList();
        for (InetAddress inetAddr : HostUtils.hostIpv4Addresses()) {
            ipv4Addresses.add(inetAddr.getHostAddress());
        }
        String ipAddresses = Joiner.on(", ").join(ipv4Addresses);
        standardTags.put("cloudAdapterIps", ipAddresses);
        standardTags.put("scalingGroup", this.config().getScalingGroup().getName());
        return standardTags;
    }

    private void takeDownSmtpAlerter() {
        if (this.smtpAlerter.get() != null) {
            this.eventBus.unregister(this.smtpAlerter.get());
        }
    }

    BaseCloudAdapterConfig config() {
        return this.config.get();
    }

    private String scalingGroup() {
        return this.config().getScalingGroup().getName();
    }

    private BaseCloudAdapterConfig.ScaleUpConfig scaleUpConfig() {
        return this.config().getScaleUpConfig();
    }

    private BaseCloudAdapterConfig.ScaleDownConfig scaleDownConfig() {
        return this.config().getScaleDownConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateMachinePool() throws CloudAdapterException {
        this.determineDesiredSizeIfUnset();
        if (this.desiredSize.get() == null) {
            LOG.warn("cannot update scaling group: haven't been able to determine initial desired size");
            return;
        }
        Object object = this.updateLock;
        synchronized (object) {
            int targetSize = this.desiredSize.get();
            try {
                this.doPoolUpdate(targetSize);
            }
            catch (Throwable e) {
                String message = String.format("failed to adjust scaling group \"%s\" to desired size %d: %s\n%s", this.scalingGroup(), targetSize, e.getMessage(), Throwables.getStackTraceAsString(e));
                this.eventBus.post(new Alert(AlertTopics.RESIZE.name(), AlertSeverity.ERROR, UtcTime.now(), message));
                throw new CloudAdapterException(message, e);
            }
        }
    }

    private void doPoolUpdate(int newSize) throws CloudAdapterException {
        LOG.info("updating pool size to desired size {}", (Object)newSize);
        MachinePool pool = this.getMachinePool();
        int poolSize = pool.getEffectiveMachines().size();
        this.terminationQueue.filter(pool.getEffectiveMachines());
        ResizePlanner resizePlanner = new ResizePlanner(pool, this.terminationQueue, this.scaleDownConfig().getVictimSelectionPolicy(), this.scaleDownConfig().getInstanceHourMargin().intValue());
        int netSize = resizePlanner.getEffectiveSize();
        ResizePlan resizePlan = resizePlanner.calculateResizePlan(newSize);
        if (resizePlan.isScaleUp()) {
            List<Machine> startedMachines = this.scaleOut(poolSize, resizePlan);
            poolSize += startedMachines.size();
        } else if (resizePlan.isScaleDown()) {
            List<ScheduledTermination> terminations = resizePlan.getToTerminate();
            LOG.info("scheduling {} server(s) for termination", (Object)terminations.size());
            for (ScheduledTermination termination : terminations) {
                this.terminationQueue.add(termination);
                LOG.debug("scheduling server {} for termination at {}", (Object)termination.getInstance().getId(), (Object)termination.getTerminationTime());
            }
            LOG.debug("termination queue: {}", (Object)this.terminationQueue);
        } else {
            LOG.info("scaling group is already properly sized ({})", (Object)netSize);
        }
        List<Machine> terminated = this.terminateOverdueMachines();
        if (!terminated.isEmpty()) {
            this.scaleInAlert(poolSize, terminated);
        }
    }

    private List<Machine> scaleOut(int originalPoolSize, ResizePlan resizePlan) throws StartMachinesException {
        LOG.info("sparing {} machine(s) from termination, placing {} new request(s)", (Object)resizePlan.getToSpare(), (Object)resizePlan.getToRequest());
        this.terminationQueue.spare(resizePlan.getToSpare());
        try {
            List<Machine> startedMachines = this.scalingGroup.startMachines(resizePlan.getToRequest(), this.scaleUpConfig());
            this.scaleOutAlert(originalPoolSize, startedMachines);
            return startedMachines;
        }
        catch (StartMachinesException e) {
            this.scaleOutAlert(originalPoolSize, e.getStartedMachines());
            throw e;
        }
    }

    private List<Machine> terminateOverdueMachines() {
        LOG.debug("checking termination queue for overdue machines: {}", (Object)this.terminationQueue);
        List<ScheduledTermination> overdueInstances = this.terminationQueue.popOverdueInstances();
        if (overdueInstances.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Machine> terminated = Lists.newArrayList();
        LOG.info("Terminating {} overdue machine(s): {}", (Object)overdueInstances.size(), (Object)overdueInstances);
        for (ScheduledTermination overdueInstance : overdueInstances) {
            String victimId = overdueInstance.getInstance().getId();
            try {
                this.scalingGroup.terminateMachine(victimId);
                terminated.add(overdueInstance.getInstance());
            }
            catch (Exception e) {
                String message = String.format("failed to terminate instance '%s': %s\n%s", victimId, e.getMessage(), Throwables.getStackTraceAsString(e));
                LOG.error(message);
                this.eventBus.post(new Alert(AlertTopics.RESIZE.name(), AlertSeverity.ERROR, UtcTime.now(), message));
            }
        }
        return terminated;
    }

    private void scaleOutAlert(Integer oldSize, List<Machine> startedMachines) {
        if (startedMachines.isEmpty()) {
            return;
        }
        int newSize = oldSize + startedMachines.size();
        String message = String.format("size of scaling group \"%s\" changed from %d to %d", this.scalingGroup(), oldSize, newSize);
        LOG.info(message);
        HashMap<String, String> tags = Maps.newHashMap();
        ArrayList<String> startedMachineIds = Lists.newArrayList();
        for (Machine startedMachine : startedMachines) {
            startedMachineIds.add(startedMachine.getId());
        }
        tags.put("startedMachines", Joiner.on(", ").join(startedMachineIds));
        this.eventBus.post(new Alert(AlertTopics.RESIZE.name(), AlertSeverity.INFO, UtcTime.now(), message, tags));
    }

    private void scaleInAlert(Integer oldSize, List<Machine> terminatedMachines) {
        int newSize = oldSize - terminatedMachines.size();
        String message = String.format("size of scaling group \"%s\" changed from %d to %d", this.scalingGroup(), oldSize, newSize);
        LOG.info(message);
        HashMap<String, String> tags = Maps.newHashMap();
        ArrayList<String> terminatedMachineIds = Lists.newArrayList();
        for (Machine terminatedMachine : terminatedMachines) {
            terminatedMachineIds.add(terminatedMachine.getId());
        }
        tags.put("terminatedMachines", Joiner.on(", ").join(terminatedMachineIds));
        this.eventBus.post(new Alert(AlertTopics.RESIZE.name(), AlertSeverity.INFO, UtcTime.now(), message, tags));
    }

    private void terminationAlert(String machineId) {
        ImmutableMap<String, String> tags = ImmutableMap.of("terminatedMachines", machineId);
        String message = String.format("Terminated machine %s.", machineId);
        this.eventBus.post(new Alert(AlertTopics.RESIZE.name(), AlertSeverity.INFO, UtcTime.now(), message, tags));
    }

    private void attachAlert(String machineId) {
        ImmutableMap<String, String> tags = ImmutableMap.of("attachedMachines", machineId);
        String message = String.format("Attached machine %s to scaling group.", machineId);
        this.eventBus.post(new Alert(AlertTopics.RESIZE.name(), AlertSeverity.INFO, UtcTime.now(), message, tags));
    }

    private void detachAlert(String machineId) {
        ImmutableMap<String, String> tags = ImmutableMap.of("detachedMachines", machineId);
        String message = String.format("Detached machine %s from scaling group.", machineId);
        this.eventBus.post(new Alert(AlertTopics.RESIZE.name(), AlertSeverity.INFO, UtcTime.now(), message, tags));
    }

    private void serviceStateAlert(String machineId, ServiceState state) {
        ImmutableMap<String, String> tags = ImmutableMap.of();
        String message = String.format("Service state set to %s for machine %s.", state.name(), machineId);
        this.eventBus.post(new Alert(AlertTopics.SERVICE_STATE.name(), AlertSeverity.INFO, UtcTime.now(), message, tags));
    }

    public class PoolUpdateTask
    implements Runnable {
        @Override
        public void run() {
            try {
                BaseCloudAdapter.this.updateMachinePool();
            }
            catch (CloudAdapterException e) {
                LOG.error(String.format("machine pool update task failed: %s", e.getMessage()), e);
            }
        }
    }
}

