/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.commons.adapter;

import com.elastisys.scale.cloudadapers.api.CloudAdapterException;
import com.elastisys.scale.cloudadapters.commons.scaledown.VictimSelectionPolicy;
import com.elastisys.scale.commons.json.JsonUtils;
import com.elastisys.scale.commons.net.smtp.ClientAuthentication;
import com.elastisys.scale.commons.net.smtp.SmtpServerSettings;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.regex.Pattern;

public class BaseCloudAdapterConfig {
    public static final int DEFAULT_POOL_UPDATE_PERIOD = 60;
    private final ScalingGroupConfig scalingGroup;
    private final ScaleUpConfig scaleUpConfig;
    private final ScaleDownConfig scaleDownConfig;
    private final AlertSettings alerts;
    private Integer poolUpdatePeriod = 60;

    public BaseCloudAdapterConfig(ScalingGroupConfig scalingGroupConfig, ScaleUpConfig scaleUpConfig, ScaleDownConfig scaleDownConfig, AlertSettings alertSettings, Integer poolUpdatePeriod) {
        this.scalingGroup = scalingGroupConfig;
        this.scaleUpConfig = scaleUpConfig;
        this.scaleDownConfig = scaleDownConfig;
        this.alerts = alertSettings;
        this.poolUpdatePeriod = poolUpdatePeriod;
    }

    public ScalingGroupConfig getScalingGroup() {
        return this.scalingGroup;
    }

    public ScaleUpConfig getScaleUpConfig() {
        return this.scaleUpConfig;
    }

    public ScaleDownConfig getScaleDownConfig() {
        return this.scaleDownConfig;
    }

    public AlertSettings getAlerts() {
        return this.alerts;
    }

    public int getPoolUpdatePeriod() {
        return Optional.fromNullable(this.poolUpdatePeriod).or(60);
    }

    public void validate() throws CloudAdapterException {
        try {
            Preconditions.checkNotNull(this.scalingGroup, "missing scalingGroup config");
            Preconditions.checkNotNull(this.scaleUpConfig, "missing scaleUpConfig");
            Preconditions.checkNotNull(this.scaleDownConfig, "missing scaleDownConfig");
            Preconditions.checkArgument(this.getPoolUpdatePeriod() > 0, "poolUpdatePeriod must be non-negative");
            this.scalingGroup.validate();
            this.scaleUpConfig.validate();
            this.scaleDownConfig.validate();
            if (this.alerts != null) {
                this.alerts.validate();
            }
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf(e, CloudAdapterException.class);
            throw new CloudAdapterException(String.format("failed to validate configuration: %s", e.getMessage()), e);
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.scalingGroup, this.scaleUpConfig, this.scaleDownConfig, this.alerts, this.poolUpdatePeriod);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BaseCloudAdapterConfig) {
            BaseCloudAdapterConfig that = (BaseCloudAdapterConfig)obj;
            return Objects.equal(this.scalingGroup, that.scalingGroup) && Objects.equal(this.scaleUpConfig, that.scaleUpConfig) && Objects.equal(this.scaleDownConfig, that.scaleDownConfig) && Objects.equal(this.alerts, that.alerts) && Objects.equal(this.poolUpdatePeriod, that.poolUpdatePeriod);
        }
        return false;
    }

    public String toString() {
        return JsonUtils.toPrettyString(JsonUtils.toJson(this, true));
    }

    public static class MailServerSettings {
        private static final int DEFAULT_SMTP_PORT = 25;
        private final String smtpHost;
        private final Integer smtpPort;
        private final ClientAuthentication authentication;
        private final Boolean useSsl;

        public MailServerSettings(String smtpHost, Integer smtpPort, ClientAuthentication authentication, boolean useSsl) {
            this.smtpHost = smtpHost;
            this.smtpPort = smtpPort;
            this.authentication = authentication;
            this.useSsl = useSsl;
        }

        public String getSmtpHost() {
            return this.smtpHost;
        }

        public Integer getSmtpPort() {
            return Optional.fromNullable(this.smtpPort).or(25);
        }

        public ClientAuthentication getAuthentication() {
            return this.authentication;
        }

        public boolean isUseSsl() {
            return Optional.fromNullable(this.useSsl).or(false);
        }

        public void validate() throws CloudAdapterException {
            try {
                SmtpServerSettings settings = new SmtpServerSettings(this.getSmtpHost(), this.getSmtpPort(), this.getAuthentication(), this.isUseSsl());
                settings.validate();
            }
            catch (Exception e) {
                throw new CloudAdapterException(String.format("failed to validate mailServerSettings: %s", e.getMessage()), e);
            }
        }

        public int hashCode() {
            return Objects.hashCode(this.getSmtpHost(), this.getSmtpPort(), this.getAuthentication(), this.isUseSsl());
        }

        public boolean equals(Object obj) {
            if (obj instanceof MailServerSettings) {
                MailServerSettings that = (MailServerSettings)obj;
                return Objects.equal(this.getSmtpHost(), that.getSmtpHost()) && Objects.equal(this.getSmtpPort(), that.getSmtpPort()) && Objects.equal(this.getAuthentication(), that.getAuthentication()) && Objects.equal(this.isUseSsl(), that.isUseSsl());
            }
            return false;
        }

        public String toString() {
            return JsonUtils.toPrettyString(JsonUtils.toJson(this, true));
        }

        public SmtpServerSettings toSmtpServerSettings() {
            return new SmtpServerSettings(this.getSmtpHost(), this.getSmtpPort(), this.getAuthentication(), this.isUseSsl());
        }
    }

    public static class AlertSettings {
        public static final String DEFAULT_SEVERITY_FILTER = ".*";
        private final String subject;
        private final List<String> recipients;
        private final String sender;
        private final String severityFilter;
        private final MailServerSettings mailServer;

        public AlertSettings(String subject, List<String> recipients, String sender, String severityFilter, MailServerSettings mailServer) {
            this.subject = subject;
            this.recipients = recipients;
            this.sender = sender;
            this.severityFilter = severityFilter;
            this.mailServer = mailServer;
        }

        public String getSubject() {
            return this.subject;
        }

        public List<String> getRecipients() {
            return this.recipients;
        }

        public String getSender() {
            return this.sender;
        }

        public MailServerSettings getMailServer() {
            return this.mailServer;
        }

        public String getSeverityFilter() {
            return Optional.fromNullable(this.severityFilter).or(DEFAULT_SEVERITY_FILTER);
        }

        public void validate() throws CloudAdapterException {
            try {
                Preconditions.checkNotNull(this.subject, "missing subject");
                Preconditions.checkNotNull(this.recipients, "missing recipients");
                Preconditions.checkNotNull(this.sender, "missing sender");
                Preconditions.checkNotNull(this.mailServer, "missing mailServer");
                this.validateSeverityFilter(this.getSeverityFilter());
                this.mailServer.validate();
            }
            catch (Exception e) {
                throw new CloudAdapterException(String.format("failed to validate alerts config: %s", e.getMessage()), e);
            }
        }

        private void validateSeverityFilter(String severityFilter) {
            try {
                Pattern.compile(severityFilter);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("illegal severity filter expression: " + e.getMessage(), e);
            }
        }

        public int hashCode() {
            return Objects.hashCode(this.subject, this.recipients, this.sender, this.mailServer, this.getSeverityFilter());
        }

        public boolean equals(Object obj) {
            if (obj instanceof AlertSettings) {
                AlertSettings that = (AlertSettings)obj;
                return Objects.equal(this.subject, that.subject) && Objects.equal(this.recipients, that.recipients) && Objects.equal(this.sender, that.sender) && Objects.equal(this.mailServer, that.mailServer) && Objects.equal(this.getSeverityFilter(), that.getSeverityFilter());
            }
            return false;
        }

        public String toString() {
            return JsonUtils.toPrettyString(JsonUtils.toJson(this, true));
        }
    }

    public static class ScaleDownConfig {
        private final VictimSelectionPolicy victimSelectionPolicy;
        private final Integer instanceHourMargin;

        public ScaleDownConfig(VictimSelectionPolicy victimSelectionPolicy, int instanceHourMargin) {
            this.victimSelectionPolicy = victimSelectionPolicy;
            this.instanceHourMargin = instanceHourMargin;
        }

        public VictimSelectionPolicy getVictimSelectionPolicy() {
            return this.victimSelectionPolicy;
        }

        public Integer getInstanceHourMargin() {
            return this.instanceHourMargin;
        }

        public void validate() throws CloudAdapterException {
            try {
                Preconditions.checkNotNull(this.victimSelectionPolicy, "victim selection policy cannot be null");
                Preconditions.checkArgument(this.instanceHourMargin < 3600, "instance hour margin must be <= 3600");
            }
            catch (Exception e) {
                throw new CloudAdapterException(String.format("failed to validate scaleDownConfig: %s", e.getMessage()), e);
            }
        }

        public int hashCode() {
            return Objects.hashCode(new Object[]{this.victimSelectionPolicy, this.instanceHourMargin});
        }

        public boolean equals(Object obj) {
            if (obj instanceof ScaleDownConfig) {
                ScaleDownConfig that = (ScaleDownConfig)obj;
                return Objects.equal((Object)this.victimSelectionPolicy, (Object)that.victimSelectionPolicy) && Objects.equal(this.instanceHourMargin, that.instanceHourMargin);
            }
            return false;
        }

        public String toString() {
            return JsonUtils.toPrettyString(JsonUtils.toJson(this, true));
        }
    }

    public static class ScaleUpConfig {
        private final String size;
        private final String image;
        private final String keyPair;
        private final List<String> securityGroups;
        private final List<String> bootScript;

        public ScaleUpConfig(String size, String image, String keyPair, List<String> securityGroups, List<String> bootScript) {
            this.size = size;
            this.image = image;
            this.keyPair = keyPair;
            this.securityGroups = securityGroups;
            this.bootScript = bootScript;
        }

        public String getSize() {
            return this.size;
        }

        public String getImage() {
            return this.image;
        }

        public String getKeyPair() {
            return this.keyPair;
        }

        public List<String> getSecurityGroups() {
            return this.securityGroups;
        }

        public List<String> getBootScript() {
            return this.bootScript;
        }

        public void validate() throws CloudAdapterException {
            try {
                Preconditions.checkNotNull(this.size, "missing size");
                Preconditions.checkNotNull(this.image, "missing image");
                Preconditions.checkNotNull(this.keyPair, "missing keyPair");
                Preconditions.checkNotNull(this.securityGroups, "missing securityGroups");
                Preconditions.checkNotNull(this.bootScript, "missing bootScript");
            }
            catch (Exception e) {
                throw new CloudAdapterException(String.format("failed to validate scaleUpConfig: %s", e.getMessage()), e);
            }
        }

        public int hashCode() {
            return Objects.hashCode(this.size, this.image, this.keyPair, this.securityGroups, this.bootScript);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ScaleUpConfig) {
                ScaleUpConfig that = (ScaleUpConfig)obj;
                return Objects.equal(this.size, that.size) && Objects.equal(this.image, that.image) && Objects.equal(this.keyPair, that.keyPair) && Objects.equal(this.securityGroups, that.securityGroups) && Objects.equal(this.bootScript, that.bootScript);
            }
            return false;
        }

        public String toString() {
            return JsonUtils.toPrettyString(JsonUtils.toJson(this, true));
        }
    }

    public static class ScalingGroupConfig {
        private final String name;
        private final JsonObject config;

        public ScalingGroupConfig(String name, JsonObject config) {
            this.name = name;
            this.config = config;
        }

        public String getName() {
            return this.name;
        }

        public JsonObject getConfig() {
            return this.config;
        }

        public void validate() throws CloudAdapterException {
            try {
                Preconditions.checkNotNull(this.name, "missing name");
                Preconditions.checkNotNull(this.config, "missing config");
            }
            catch (Exception e) {
                throw new CloudAdapterException(String.format("failed to validate scalingGroup configuration: %s", e.getMessage()), e);
            }
        }

        public int hashCode() {
            return Objects.hashCode(this.name, this.config);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ScalingGroupConfig) {
                ScalingGroupConfig that = (ScalingGroupConfig)obj;
                return Objects.equal(this.name, that.name) && Objects.equal(this.config, that.config);
            }
            return false;
        }

        public String toString() {
            return JsonUtils.toPrettyString(JsonUtils.toJson(this, true));
        }
    }
}

