/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.commons.adapter.scalinggroup;

import com.elastisys.scale.cloudadapers.api.types.Machine;
import com.elastisys.scale.cloudadapters.commons.adapter.scalinggroup.ScalingGroupException;
import java.util.List;

public class StartMachinesException
extends ScalingGroupException {
    private static final long serialVersionUID = 1L;
    private final int requestedMachines;
    private final List<Machine> startedMachines;

    public StartMachinesException(int requestedMachines, List<Machine> startedMachines, Throwable cause) {
        this(requestedMachines, startedMachines, cause, StartMachinesException.defaultErrorMessage(requestedMachines, startedMachines, cause));
    }

    public StartMachinesException(int requestedMachines, List<Machine> startedMachines, Throwable cause, String message) {
        super(message, cause);
        this.requestedMachines = requestedMachines;
        this.startedMachines = startedMachines;
    }

    public int getRequestedMachines() {
        return this.requestedMachines;
    }

    public List<Machine> getStartedMachines() {
        return this.startedMachines;
    }

    private static String defaultErrorMessage(int numRequestedMachines, List<Machine> startedMachines, Throwable cause) {
        String message = String.format("failure to complete request to start %d machine(s) (%d machine(s) were launched): %s", numRequestedMachines, startedMachines.size(), cause.getMessage());
        return message;
    }
}

