/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.commons.resizeplanner;

import com.elastisys.scale.cloudadapters.commons.termqueue.ScheduledTermination;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;

public class ResizePlan {
    private final int toRequest;
    private final int toSpare;
    private final List<ScheduledTermination> toTerminate;

    public ResizePlan(int toRequest, int toSpare, List<ScheduledTermination> toTerminate) {
        this.toSpare = toSpare;
        this.toRequest = toRequest;
        this.toTerminate = Optional.fromNullable(toTerminate).or(new ArrayList());
        this.validate();
    }

    public void validate() throws IllegalArgumentException {
        Preconditions.checkArgument(this.toSpare >= 0, "negative number of machines to spare");
        Preconditions.checkArgument(this.toRequest >= 0, "negative number of additional machines to request");
        int decrease = this.toTerminate.size();
        int increase = this.toSpare + this.toRequest;
        if (decrease > 0 && increase > 0) {
            throw new IllegalArgumentException("resize plan is ambigous: suggests both increasing and decreasing pool");
        }
    }

    public int getToSpare() {
        return this.toSpare;
    }

    public int getToRequest() {
        return this.toRequest;
    }

    public List<ScheduledTermination> getToTerminate() {
        return this.toTerminate;
    }

    public boolean isScaleUp() {
        return this.toRequest > 0 || this.toSpare > 0;
    }

    public boolean isScaleDown() {
        return !this.toTerminate.isEmpty();
    }

    public int hashCode() {
        return Objects.hashCode(this.toRequest, this.toSpare, this.toTerminate);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResizePlan) {
            ResizePlan that = (ResizePlan)obj;
            return Objects.equal(this.toRequest, that.toRequest) && Objects.equal(this.toSpare, that.toSpare) && Objects.equal(this.toTerminate, that.toTerminate);
        }
        return super.equals(obj);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("toRequest", this.toRequest).add("toSpare", this.toSpare).add("toTerminate", this.toTerminate).toString();
    }
}

