/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.commons.resizeplanner;

import com.elastisys.scale.cloudadapers.api.types.Machine;
import com.elastisys.scale.cloudadapers.api.types.MachinePool;
import com.elastisys.scale.cloudadapers.api.types.MachineState;
import com.elastisys.scale.cloudadapters.commons.resizeplanner.ResizePlan;
import com.elastisys.scale.cloudadapters.commons.scaledown.TerminationScheduler;
import com.elastisys.scale.cloudadapters.commons.scaledown.VictimSelectionPolicy;
import com.elastisys.scale.cloudadapters.commons.scaledown.VictimSelector;
import com.elastisys.scale.cloudadapters.commons.termqueue.ScheduledTermination;
import com.elastisys.scale.cloudadapters.commons.termqueue.TerminationQueue;
import com.elastisys.scale.commons.util.time.UtcTime;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResizePlanner {
    static final Logger LOG = LoggerFactory.getLogger(ResizePlanner.class);
    private final MachinePool machinePool;
    private final TerminationQueue terminationQueue;
    private final VictimSelectionPolicy victimSelectionPolicy;
    private final long instanceHourMargin;

    public ResizePlanner(MachinePool machinePool, TerminationQueue terminationQueue, VictimSelectionPolicy victimSelectionPolicy, long instanceHourMargin) {
        this.machinePool = machinePool;
        this.terminationQueue = terminationQueue;
        this.victimSelectionPolicy = victimSelectionPolicy;
        this.instanceHourMargin = instanceHourMargin;
        this.validate();
    }

    public void validate() throws IllegalArgumentException {
        Preconditions.checkArgument(this.machinePool != null, "missing machinePool");
        Preconditions.checkArgument(this.terminationQueue != null, "missing termination queue");
        Preconditions.checkArgument(this.victimSelectionPolicy != null, "missing victim selection policy");
        long hourSeconds = TimeUnit.SECONDS.convert(1L, TimeUnit.HOURS);
        Preconditions.checkArgument(Range.closedOpen(0L, hourSeconds).contains(this.instanceHourMargin), "instanceHourMargin must be within interval [0, 3600) seconds.");
    }

    public int getEffectiveSize() {
        List<Machine> effectiveMembers = this.effectiveMembers(this.machinePool);
        int currentPoolSize = effectiveMembers.size();
        int termQueueSize = this.terminationQueue.size();
        int netSize = currentPoolSize - termQueueSize;
        return netSize;
    }

    public ResizePlan calculateResizePlan(int desiredSize) {
        Preconditions.checkArgument(desiredSize >= 0, "desired pool size must be >= 0");
        int toRequest = 0;
        int toSpare = 0;
        ArrayList<ScheduledTermination> toTerminate = Lists.newArrayList();
        List<Machine> effectiveMachines = this.machinePool.getEffectiveMachines();
        int effectivePoolSize = effectiveMachines.size();
        int allocated = this.machinePool.getAllocatedMachines().size();
        int outOfService = this.machinePool.getOutOfServiceMachines().size();
        int termQueueSize = this.terminationQueue.size();
        int netSize = this.getEffectiveSize();
        LOG.debug("desired pool size: {}, effective pool size: {} (allocated: {}, out-of-service: {}), net size (excluding termination-queued): {}, termination queue: {}", desiredSize, effectivePoolSize, allocated, outOfService, netSize, this.terminationQueue);
        if (desiredSize > netSize) {
            int missingMachines = desiredSize - netSize;
            toSpare = Math.min(termQueueSize, missingMachines);
            toRequest = missingMachines - toSpare;
        } else if (desiredSize < netSize) {
            int excessMachines = netSize - desiredSize;
            toTerminate = this.scheduleForTermination(excessMachines);
        } else {
            LOG.debug("desired size {} equals net pool size, nothing to do", (Object)desiredSize);
        }
        ResizePlan resizePlan = new ResizePlan(toRequest, toSpare, toTerminate);
        LOG.debug("suggested resize plan: {}", (Object)resizePlan);
        return resizePlan;
    }

    private List<ScheduledTermination> scheduleForTermination(int excessMachines) {
        ArrayList<ScheduledTermination> toTerminate = Lists.newArrayList();
        List<Machine> candidates = this.effectiveMembers(this.machinePool);
        LOG.debug("need to select {} victim(s) for termination from {} effective machine(s)", (Object)excessMachines, (Object)candidates.size());
        Collection<? super Machine> inRequestedState = Collections2.filter(candidates, Machine.withState(MachineState.REQUESTED));
        Iterator requestedStateMachines = inRequestedState.iterator();
        while (excessMachines > 0 && requestedStateMachines.hasNext()) {
            toTerminate.add(new ScheduledTermination((Machine)requestedStateMachines.next(), UtcTime.now()));
            --excessMachines;
        }
        candidates.removeAll(Lists.newArrayList(inRequestedState));
        List<Machine> victims = this.victimSelector().selectVictims(candidates, excessMachines);
        for (Machine victim : victims) {
            toTerminate.add(this.scheduleTermination(victim));
        }
        return toTerminate;
    }

    private ScheduledTermination scheduleTermination(Machine victim) {
        return new TerminationScheduler(this.instanceHourMargin).scheduleEviction(victim);
    }

    private VictimSelector victimSelector() {
        return new VictimSelector(this.terminationQueue, this.victimSelectionPolicy.getVictimSelectionStrategy());
    }

    private List<Machine> effectiveMembers(MachinePool machinePool) {
        return machinePool.getEffectiveMachines();
    }
}

