/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.commons.scaledown;

import com.elastisys.scale.cloudadapers.api.types.Machine;
import com.elastisys.scale.cloudadapters.commons.termqueue.ScheduledTermination;
import com.elastisys.scale.commons.util.time.UtcTime;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

public class TerminationScheduler {
    private final long instanceHourMargin;

    public TerminationScheduler(long instanceHourMargin) {
        Preconditions.checkArgument(instanceHourMargin < 3600L, "instanceHourMargin must be smaller than 3600 seconds");
        this.instanceHourMargin = instanceHourMargin;
    }

    public List<ScheduledTermination> scheduleEvictions(List<Machine> victims) {
        Preconditions.checkNotNull(victims, "null victims");
        ArrayList<ScheduledTermination> evictions = Lists.newArrayList();
        for (Machine victim : victims) {
            evictions.add(this.scheduleEviction(victim));
        }
        return evictions;
    }

    public ScheduledTermination scheduleEviction(Machine victim) {
        Preconditions.checkNotNull(victim, "null victim");
        Preconditions.checkNotNull(victim.getLaunchtime(), "cannot schedule termination for a machine instance without launch time");
        DateTime terminationTime = this.calculateTerminationTime(victim, this.instanceHourMargin);
        return new ScheduledTermination(victim, terminationTime);
    }

    private DateTime calculateTerminationTime(Machine victim, long instanceHourMargin) {
        if (instanceHourMargin <= 0L) {
            return UtcTime.now();
        }
        long secondsLeftOfInstanceHour = Machine.remainingInstanceHourTime().apply(victim);
        long secondsLeftOfInstanceHourWithMargin = secondsLeftOfInstanceHour - instanceHourMargin;
        secondsLeftOfInstanceHourWithMargin = Math.max(secondsLeftOfInstanceHourWithMargin, 0L);
        DateTime terminationTime = UtcTime.now().plusSeconds((int)secondsLeftOfInstanceHourWithMargin);
        return terminationTime;
    }
}

