/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.commons.scaledown;

import com.elastisys.scale.cloudadapers.api.types.Machine;
import com.elastisys.scale.cloudadapters.commons.scaledown.VictimSelectionStrategy;
import com.elastisys.scale.cloudadapters.commons.termqueue.TerminationQueue;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class VictimSelector {
    private final TerminationQueue terminationQueue;
    private final VictimSelectionStrategy victimSelectionStrategy;

    public VictimSelector(TerminationQueue terminationQueue, VictimSelectionStrategy victimSelectionStrategy) {
        Preconditions.checkNotNull(terminationQueue, "null terminationQueue");
        Preconditions.checkNotNull(victimSelectionStrategy, "null victimSelectionStrategy");
        this.terminationQueue = terminationQueue;
        this.victimSelectionStrategy = victimSelectionStrategy;
    }

    public List<Machine> selectVictims(List<Machine> candidates, long numVictims) throws IllegalArgumentException {
        Preconditions.checkNotNull(candidates, "null candidates");
        Preconditions.checkArgument(numVictims >= 0L, "negative number of victims");
        Preconditions.checkArgument((long)candidates.size() >= numVictims, "more victims than candidates");
        ArrayList<Machine> victims = Lists.newArrayList();
        List<Machine> terminationCandidates = this.getTerminationCandidates(candidates);
        Preconditions.checkArgument((long)terminationCandidates.size() >= numVictims, "more victims (%s) than eligble termination candidates (%s)", numVictims, terminationCandidates.size());
        int i = 0;
        while ((long)i < numVictims) {
            Machine victim = this.victimSelectionStrategy.selectVictim(terminationCandidates);
            victims.add(victim);
            terminationCandidates.remove(victim);
            ++i;
        }
        return victims;
    }

    private List<Machine> getTerminationCandidates(List<Machine> machines) {
        List<Machine> terminationMarked = this.terminationQueue.getQueuedInstances();
        return Lists.newArrayList(Iterables.filter(machines, Predicates.not(Predicates.in(terminationMarked))));
    }
}

