/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.commons.scaledown.strategies;

import com.elastisys.scale.cloudadapers.api.types.Machine;
import com.elastisys.scale.cloudadapters.commons.scaledown.VictimSelectionStrategy;
import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.List;

public enum ClosestToInstanceHourVictimSelectionStrategy implements VictimSelectionStrategy
{
    INSTANCE;


    @Override
    public Machine selectVictim(List<Machine> candidates) throws IllegalArgumentException {
        Preconditions.checkNotNull(candidates, "null candidate set");
        Preconditions.checkArgument(!candidates.isEmpty(), "empty candidate set");
        return Machine.sort(candidates, new ClosestToInstanceHourOrder()).get(0);
    }

    public class ClosestToInstanceHourOrder
    implements Comparator<Machine> {
        @Override
        public int compare(Machine instance1, Machine instance2) {
            Machine.RemainingInstanceHourTime remainingInstanceHourTime = new Machine.RemainingInstanceHourTime();
            long i1TimeLeft = (Long)remainingInstanceHourTime.apply(instance1);
            long i2TimeLeft = (Long)remainingInstanceHourTime.apply(instance2);
            return (int)(i1TimeLeft - i2TimeLeft);
        }
    }
}

