/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.commons.scaledown.strategies;

import com.elastisys.scale.cloudadapers.api.types.Machine;
import com.elastisys.scale.cloudadapters.commons.scaledown.VictimSelectionStrategy;
import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.List;

public enum NewestInstanceVictimSelectionStrategy implements VictimSelectionStrategy
{
    INSTANCE;


    @Override
    public Machine selectVictim(List<Machine> candidates) throws IllegalArgumentException {
        Preconditions.checkNotNull(candidates, "null candidate set");
        Preconditions.checkArgument(!candidates.isEmpty(), "empty candidate set");
        return Machine.sort(candidates, new NewestFirstOrder()).get(0);
    }

    public class NewestFirstOrder
    implements Comparator<Machine> {
        @Override
        public int compare(Machine instance1, Machine instance2) {
            return instance2.getLaunchtime().compareTo(instance1.getLaunchtime());
        }
    }
}

