/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.commons.scaledown.strategies;

import com.elastisys.scale.cloudadapers.api.types.Machine;
import com.elastisys.scale.cloudadapters.commons.scaledown.VictimSelectionStrategy;
import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.List;

public enum OldestInstanceVictimSelectionStrategy implements VictimSelectionStrategy
{
    INSTANCE;


    @Override
    public Machine selectVictim(List<Machine> candidates) throws IllegalArgumentException {
        Preconditions.checkNotNull(candidates, "null candidate set");
        Preconditions.checkArgument(!candidates.isEmpty(), "empty candidate set");
        return Machine.sort(candidates, new OldestFirstOrder()).get(0);
    }

    public static class OldestFirstOrder
    implements Comparator<Machine> {
        @Override
        public int compare(Machine instance1, Machine instance2) {
            return instance1.getLaunchtime().compareTo(instance2.getLaunchtime());
        }
    }
}

