/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.commons.termqueue;

import com.elastisys.scale.cloudadapers.api.types.Machine;
import com.elastisys.scale.cloudadapters.commons.termqueue.ScheduledTermination;
import com.elastisys.scale.commons.util.time.UtcTime;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.PriorityQueue;
import org.joda.time.DateTime;

public class TerminationQueue {
    private final PriorityQueue<ScheduledTermination> scheduledTerminations = new PriorityQueue();

    public void add(ScheduledTermination scheduledTermination) {
        Preconditions.checkNotNull(scheduledTermination, "attempt to add a null scheduled termination");
        this.scheduledTerminations.add(scheduledTermination);
    }

    public void addAll(Collection<ScheduledTermination> scheduledTerminations) {
        Preconditions.checkNotNull(scheduledTerminations, "null scheduled terminations");
        for (ScheduledTermination scheduledTermination : scheduledTerminations) {
            this.add(scheduledTermination);
        }
    }

    public List<Machine> getQueuedInstances() {
        Object[] orderedArray = this.scheduledTerminations.toArray(new ScheduledTermination[0]);
        Arrays.sort(orderedArray);
        ArrayList<Machine> instances = Lists.newArrayList();
        for (Object scheduledTermination : orderedArray) {
            instances.add(((ScheduledTermination)scheduledTermination).getInstance());
        }
        return instances;
    }

    public int size() {
        return this.scheduledTerminations.size();
    }

    public List<ScheduledTermination> spare(long numInstancesToSpare) throws IllegalArgumentException {
        Preconditions.checkArgument(numInstancesToSpare >= 0L, "numInstancesToSpare must be non-negative");
        Preconditions.checkArgument(numInstancesToSpare <= (long)this.size(), "Requested %s termination-marked instances to be spared but there are only %s termination-marked instances.", numInstancesToSpare, this.size());
        ArrayList<ScheduledTermination> sparedInstances = Lists.newArrayList();
        int i = 0;
        while ((long)i < numInstancesToSpare) {
            ScheduledTermination sparedInstance = this.scheduledTerminations.poll();
            sparedInstances.add(sparedInstance);
            ++i;
        }
        return sparedInstances;
    }

    public List<ScheduledTermination> popOverdueInstances() {
        ArrayList<ScheduledTermination> effectuatedTerminations = Lists.newArrayList();
        DateTime now = UtcTime.now();
        Object[] orderedArray = this.scheduledTerminations.toArray(new ScheduledTermination[0]);
        Arrays.sort(orderedArray);
        for (Object nextInstanceTermination : orderedArray) {
            if (now.isBefore(((ScheduledTermination)nextInstanceTermination).getTerminationTime())) break;
            effectuatedTerminations.add((ScheduledTermination)nextInstanceTermination);
            this.scheduledTerminations.remove(nextInstanceTermination);
        }
        return effectuatedTerminations;
    }

    public void filter(Collection<Machine> poolMembers) {
        ArrayList<ScheduledTermination> terminations = Lists.newArrayList(this.scheduledTerminations);
        for (ScheduledTermination termination : terminations) {
            if (poolMembers.contains(termination.getInstance())) continue;
            this.scheduledTerminations.remove(termination);
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.scheduledTerminations);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TerminationQueue) {
            TerminationQueue that = (TerminationQueue)TerminationQueue.class.cast(obj);
            return Objects.equal(this.scheduledTerminations, that.scheduledTerminations);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (ScheduledTermination scheduledTermination : this.scheduledTerminations) {
            sb.append(" " + scheduledTermination.getInstance().getId() + ":" + scheduledTermination.getTerminationTime());
        }
        sb.append(" ]");
        return sb.toString();
    }
}

