/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.commons.util.cli;

import com.elastisys.scale.cloudadapers.api.CloudAdapter;
import com.elastisys.scale.cloudadapers.api.types.Machine;
import com.elastisys.scale.cloudadapers.api.types.ServiceState;
import com.elastisys.scale.commons.json.JsonUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;

public class CloudadapterCommandLineDriver {
    private final CloudAdapter cloudAdapter;

    public CloudadapterCommandLineDriver(CloudAdapter cloudadapter) {
        this.cloudAdapter = cloudadapter;
    }

    private void prompt() {
        List<String> commands = Arrays.asList("config                    -- get config", "setconfig <path>          -- set config", "size                      -- get pool size", "setsize <num>             -- set desired size", "pool [verbose?]           -- get pool members", "attach <id>               -- attach instance to pool", "detach <id> <size--?>     -- detach instance from pool", "setstate <id> <state>     -- set instance service state", "terminate <id> <size--?>  -- terminate a pool member", "exit                      -- quit");
        System.err.println("Commands:");
        System.err.println(Joiner.on("\n").join(commands));
        System.err.print(">> ");
    }

    public void start() {
        this.prompt();
        try (Scanner scanner = new Scanner(System.in);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                if (line.isEmpty()) continue;
                List<String> tokens = Arrays.asList(line.split("\\s+"));
                String command = tokens.get(0);
                List<String> args = tokens.subList(1, tokens.size());
                try {
                    this.runCommand(command, args);
                }
                catch (Exception e) {
                    System.err.printf("failed to execute '%s':\n%s\n", command, e);
                    e.printStackTrace();
                }
                this.prompt();
            }
        }
    }

    private void runCommand(String command, List<String> args) {
        switch (command) {
            case "config": {
                System.out.println(JsonUtils.toPrettyString(this.cloudAdapter.getConfiguration().get()));
                break;
            }
            case "setconfig": {
                Preconditions.checkArgument(args.size() > 0, "error: setconfig requires an argument");
                File configFile = new File(args.get(0));
                Preconditions.checkArgument(configFile.isFile(), "error: given path is not a file");
                this.cloudAdapter.configure(JsonUtils.parseJsonFile(configFile));
                break;
            }
            case "size": {
                System.out.println(this.cloudAdapter.getPoolSize());
                break;
            }
            case "setsize": {
                Preconditions.checkArgument(args.size() > 0, "error: setsize requires an argument");
                this.cloudAdapter.setDesiredSize(Integer.valueOf(args.get(0)));
                break;
            }
            case "pool": {
                boolean verbose = !args.isEmpty() && Boolean.valueOf(args.get(0)) != false;
                List<Machine> machines = this.cloudAdapter.getMachinePool().getMachines();
                if (verbose) {
                    System.out.println(Joiner.on("\n").join(machines));
                    break;
                }
                System.out.println(Joiner.on("\n").join(Lists.transform(machines, Machine.toShortFormat())));
                break;
            }
            case "attach": {
                Preconditions.checkArgument(args.size() > 0, "error: attach requires an argument");
                this.cloudAdapter.attachMachine(args.get(0));
                break;
            }
            case "detach": {
                Preconditions.checkArgument(args.size() > 1, "error: attach requires two arguments: <instance-id> <size--?: true|false>");
                this.cloudAdapter.detachMachine(args.get(0), Boolean.valueOf(args.get(1)));
                break;
            }
            case "setstate": {
                Preconditions.checkArgument(args.size() > 1, "error: setstate requires two arguments: <instance-id> <state>");
                this.cloudAdapter.setServiceState(args.get(0), ServiceState.valueOf(args.get(1)));
                break;
            }
            case "terminate": {
                Preconditions.checkArgument(args.size() > 1, "error: terminate requires two arguments: <instance-id> <size--? true|false>");
                this.cloudAdapter.terminateMachine(args.get(0), Boolean.valueOf(args.get(1)));
                break;
            }
            case "exit": {
                System.out.println("Exiting ...");
                System.exit(0);
                break;
            }
            default: {
                System.err.println(String.format("error: unrecognized command '%s'", command));
            }
        }
    }
}

