/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.openstack.functions;

import com.elastisys.scale.cloudadapers.api.types.Machine;
import com.elastisys.scale.cloudadapers.api.types.MachineState;
import com.elastisys.scale.cloudadapers.api.types.ServiceState;
import com.elastisys.scale.cloudadapters.openstack.functions.StatusToMachineState;
import com.elastisys.scale.commons.json.JsonUtils;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import org.jclouds.openstack.nova.v2_0.domain.Address;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.util.InetAddresses2;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ServerToMachine
implements Function<Server, Machine> {
    public static Machine convert(Server server) {
        return new ServerToMachine().apply(server);
    }

    @Override
    public Machine apply(Server server) {
        return ServerToMachine.asMachine(server);
    }

    private static Machine asMachine(Server server) {
        MachineState machineState = new StatusToMachineState().apply(server.getStatus());
        DateTime launchTime = new DateTime((Object)server.getCreated(), DateTimeZone.UTC);
        ArrayList<String> publicIps = Lists.newArrayList();
        ArrayList<String> privateIps = Lists.newArrayList();
        Collection<Address> ipAddresses = server.getAddresses().values();
        for (Address ipAddress : ipAddresses) {
            String ip = ipAddress.getAddr();
            if (InetAddresses2.IsPrivateIPAddress.INSTANCE.apply(ip)) {
                privateIps.add(ip);
                continue;
            }
            publicIps.add(ip);
        }
        ServiceState serviceState = ServiceState.UNKNOWN;
        if (server.getMetadata().containsKey("elastisys:serviceState")) {
            serviceState = ServiceState.valueOf(server.getMetadata().get("elastisys:serviceState"));
        }
        JsonObject metadata = JsonUtils.toJson(server).getAsJsonObject();
        return new Machine(server.getId(), machineState, serviceState, launchTime, publicIps, privateIps, metadata);
    }
}

