/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.openstack.functions;

import com.elastisys.scale.cloudadapers.api.types.MachineState;
import com.google.common.base.Function;
import java.util.Arrays;
import org.jclouds.openstack.nova.v2_0.domain.Server;

public class StatusToMachineState
implements Function<Server.Status, MachineState> {
    @Override
    public MachineState apply(Server.Status state) {
        if (Arrays.asList(Server.Status.ACTIVE, Server.Status.ERROR, Server.Status.PASSWORD).contains((Object)state)) {
            return MachineState.RUNNING;
        }
        if (Arrays.asList(Server.Status.BUILD, Server.Status.REBUILD, Server.Status.REBOOT, Server.Status.HARD_REBOOT, Server.Status.RESIZE, Server.Status.REVERT_RESIZE, Server.Status.VERIFY_RESIZE).contains((Object)state)) {
            return MachineState.PENDING;
        }
        if (Arrays.asList(Server.Status.STOPPED, Server.Status.SHUTOFF, Server.Status.PAUSED, Server.Status.SUSPENDED, Server.Status.DELETED).contains((Object)state)) {
            return MachineState.TERMINATED;
        }
        throw new IllegalArgumentException(String.format("unrecognized instance state \"%s\"", new Object[]{state}));
    }
}

