/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.openstack.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import org.jclouds.openstack.nova.v2_0.domain.Server;

public class ServerPredicates {
    public static Predicate<? super Server> withTag(final String tag, final String tagValue) {
        Preconditions.checkNotNull(tag, "tag cannot be null");
        Preconditions.checkNotNull(tagValue, "tag value cannot be null");
        return new Predicate<Server>(){

            @Override
            public boolean apply(Server server) {
                Map<String, String> metadata = server.getMetadata();
                return metadata.containsKey(tag) && metadata.get(tag).equals(tagValue);
            }
        };
    }

    public static Predicate<? super Server> withStateIn(final Server.Status ... statuses) {
        Preconditions.checkNotNull(statuses, "statuses cannot be null");
        return new Predicate<Server>(){

            @Override
            public boolean apply(Server server) {
                HashSet<Server.Status> allowedStatuses = Sets.newHashSet(statuses);
                return allowedStatuses.contains((Object)server.getStatus());
            }
        };
    }
}

