/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.openstack.requests;

import com.elastisys.scale.cloudadapters.openstack.scalinggroup.OpenStackScalingGroupConfig;
import com.elastisys.scale.cloudadapters.openstack.utils.OpenstackApiUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNovaRequest<R>
implements Callable<R> {
    static Logger LOG = LoggerFactory.getLogger(AbstractNovaRequest.class);
    private final OpenStackScalingGroupConfig account;

    public AbstractNovaRequest(OpenStackScalingGroupConfig account) {
        Preconditions.checkNotNull(account, "account config cannot be null");
        this.account = account;
    }

    public OpenStackScalingGroupConfig getAccount() {
        return this.account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R call() throws RuntimeException {
        R r;
        NovaApi api = OpenstackApiUtils.getNativeApi(this.account);
        try {
            r = this.doRequest(api);
        }
        catch (Throwable throwable) {
            try {
                api.close();
            }
            catch (IOException e) {
                LOG.warn(String.format("failed to close NovaApi: %s", e.getMessage()), e);
            }
            throw throwable;
        }
        try {
            api.close();
        }
        catch (IOException e) {
            LOG.warn(String.format("failed to close NovaApi: %s", e.getMessage()), e);
        }
        return r;
    }

    public abstract R doRequest(NovaApi var1) throws RuntimeException;
}

