/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.openstack.requests;

import com.elastisys.scale.cloudadapters.openstack.faults.FloatingIpAddressException;
import com.elastisys.scale.cloudadapters.openstack.requests.AbstractNovaRequest;
import com.elastisys.scale.cloudadapters.openstack.scalinggroup.OpenStackScalingGroupConfig;
import com.elastisys.scale.cloudadapters.openstack.tasks.ServerIpAddressRequester;
import com.elastisys.scale.commons.net.retryable.Retryable;
import com.elastisys.scale.commons.net.retryable.Retryers;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Address;
import org.jclouds.openstack.nova.v2_0.domain.FloatingIP;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.extensions.FloatingIPApi;
import org.jclouds.openstack.nova.v2_0.features.ServerApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignFloatingIpRequest
extends AbstractNovaRequest<String> {
    static final Logger LOG = LoggerFactory.getLogger(AssignFloatingIpRequest.class);
    private final Server server;

    public AssignFloatingIpRequest(OpenStackScalingGroupConfig account, Server server) {
        super(account);
        this.server = server;
    }

    @Override
    public String doRequest(NovaApi api) throws FloatingIpAddressException {
        try {
            return this.assignFloatingIp(api, this.server);
        }
        catch (Exception e) {
            throw new FloatingIpAddressException(String.format("failed to assign floating IP address to server \"%s\": %s", this.server.getId(), e.getMessage()), e);
        }
    }

    private String assignFloatingIp(NovaApi api, Server server) throws Exception {
        LOG.debug("assigning a floating IP address to {} ...", (Object)server.getId());
        ServerApi serverApi = api.getServerApiForZone(this.getAccount().getRegion());
        this.waitForPrivateIpAddress(serverApi, server);
        FloatingIPApi floatingIPApi = api.getFloatingIPExtensionForZone(this.getAccount().getRegion()).get();
        ArrayList<FloatingIP> floatingIps = Lists.newArrayList(floatingIPApi.list());
        List<FloatingIP> freeFloatingIps = this.getFreeFloatingIps(floatingIps);
        if (freeFloatingIps.isEmpty()) {
            freeFloatingIps.add(floatingIPApi.create());
        }
        if (freeFloatingIps.isEmpty()) {
            throw new FloatingIpAddressException("no floating IP address(es) available");
        }
        FloatingIP ipToAllocate = Iterables.getLast(freeFloatingIps);
        String ip = ipToAllocate.getIp();
        LOG.debug("assigning floating ip {} to server {}", (Object)ip, (Object)server.getId());
        floatingIPApi.addToServer(ip, server.getId());
        return ip;
    }

    private Multimap<String, Address> waitForPrivateIpAddress(ServerApi serverApi, Server server) throws Exception {
        String taskName = String.format("ip-address-waiter{%s}", server.getId());
        ServerIpAddressRequester serverIpRequester = new ServerIpAddressRequester(serverApi, server.getId());
        int fixedDelay = 6;
        int maxRetries = 10;
        Retryable<Multimap<String, Address>> retryer = Retryers.fixedDelayRetryer(taskName, serverIpRequester, fixedDelay, TimeUnit.SECONDS, maxRetries, this.ipAddressAssigned());
        return retryer.call();
    }

    private Predicate<Multimap<String, Address>> ipAddressAssigned() {
        return new Predicate<Multimap<String, Address>>(){

            @Override
            public boolean apply(Multimap<String, Address> addresses) {
                return !addresses.isEmpty();
            }
        };
    }

    private List<FloatingIP> getFreeFloatingIps(List<FloatingIP> floatingIps) {
        ArrayList<FloatingIP> unassigned = Lists.newArrayList();
        for (FloatingIP floatingIP : floatingIps) {
            if (floatingIP.getInstanceId() != null) continue;
            unassigned.add(floatingIP);
        }
        return unassigned;
    }
}

