/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.openstack.requests;

import com.elastisys.scale.cloudadapters.commons.adapter.scalinggroup.ScalingGroupException;
import com.elastisys.scale.cloudadapters.openstack.requests.AbstractNovaRequest;
import com.elastisys.scale.cloudadapters.openstack.requests.ListImagesRequest;
import com.elastisys.scale.cloudadapters.openstack.requests.ListSizesRequest;
import com.elastisys.scale.cloudadapters.openstack.scalinggroup.OpenStackScalingGroupConfig;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Flavor;
import org.jclouds.openstack.nova.v2_0.domain.Image;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.domain.ServerCreated;
import org.jclouds.openstack.nova.v2_0.features.ServerApi;
import org.jclouds.openstack.nova.v2_0.options.CreateServerOptions;

public class CreateServerRequest
extends AbstractNovaRequest<Server> {
    private final String serverName;
    private final String flavorName;
    private final String imageName;
    private final String keyPair;
    private final List<String> securityGroups;
    private final Optional<String> userData;
    private final Map<String, String> metadata;

    public CreateServerRequest(OpenStackScalingGroupConfig account, String serverName, String flavorName, String imageName, String keyPair, List<String> securityGroups, Optional<String> userData, Map<String, String> metadata) {
        super(account);
        Preconditions.checkNotNull(serverName, "server name cannot be null");
        Preconditions.checkNotNull(flavorName, "flavor name cannot be null");
        Preconditions.checkNotNull(imageName, "image name cannot be null");
        Preconditions.checkNotNull(keyPair, "keyPair cannot be null");
        Preconditions.checkNotNull(securityGroups, "securityGroups cannot be null");
        Preconditions.checkNotNull(metadata, "metadata map cannot be null");
        this.serverName = serverName;
        this.flavorName = flavorName;
        this.imageName = imageName;
        this.keyPair = keyPair;
        this.securityGroups = securityGroups;
        this.userData = userData;
        this.metadata = metadata;
    }

    @Override
    public Server doRequest(NovaApi api) {
        CreateServerOptions serverOptions = new CreateServerOptions();
        serverOptions.keyPairName(this.keyPair);
        serverOptions.securityGroupNames(this.securityGroups);
        serverOptions.metadata(this.metadata);
        if (this.userData.isPresent()) {
            serverOptions.userData(this.userData.get().getBytes());
        }
        ServerApi serverApi = api.getServerApiForZone(this.getAccount().getRegion());
        ServerCreated serverCreated = serverApi.create(this.serverName, this.getImageId(), this.getFlavorId(), serverOptions);
        return serverApi.get(serverCreated.getId());
    }

    private String getFlavorId() throws IllegalArgumentException, ScalingGroupException {
        List flavors;
        try {
            flavors = (List)new ListSizesRequest(this.getAccount()).call();
        }
        catch (Exception e) {
            throw new ScalingGroupException(String.format("failed to fetch the list of available flavors: %s", e.getMessage()), e);
        }
        for (Flavor flavor : flavors) {
            if (!flavor.getName().equals(this.flavorName)) continue;
            return flavor.getId();
        }
        throw new IllegalArgumentException(String.format("failed to create server: no flavor with name \"%s\" exists in region \"%s\"", this.flavorName, this.getAccount().getRegion()));
    }

    private String getImageId() throws IllegalArgumentException, ScalingGroupException {
        List images;
        try {
            images = (List)new ListImagesRequest(this.getAccount()).call();
        }
        catch (Exception e) {
            throw new ScalingGroupException(String.format("failed to fetch the list of available images: %s", e.getMessage()), e);
        }
        for (Image image : images) {
            if (!image.getName().equals(this.imageName)) continue;
            return image.getId();
        }
        throw new IllegalArgumentException(String.format("failed to create server: no image with name \"%s\" exists in region \"%s\"", this.imageName, this.getAccount().getRegion()));
    }
}

