/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.openstack.requests;

import com.elastisys.scale.cloudadapers.api.NotFoundException;
import com.elastisys.scale.cloudadapters.openstack.requests.AbstractNovaRequest;
import com.elastisys.scale.cloudadapters.openstack.scalinggroup.OpenStackScalingGroupConfig;
import com.google.common.base.Preconditions;
import java.util.List;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.features.ServerApi;

public class DeleteServerMetadataRequest
extends AbstractNovaRequest<Void> {
    private final String serverId;
    private final List<String> metadataKeysToDelete;

    public DeleteServerMetadataRequest(OpenStackScalingGroupConfig account, String serverId, List<String> metadataKeysToDelete) {
        super(account);
        Preconditions.checkNotNull(serverId, "server id cannot be null");
        Preconditions.checkNotNull(metadataKeysToDelete, "metadata keys cannot be null");
        this.serverId = serverId;
        this.metadataKeysToDelete = metadataKeysToDelete;
    }

    @Override
    public Void doRequest(NovaApi api) throws NotFoundException {
        ServerApi serverApi = api.getServerApiForZone(this.getAccount().getRegion());
        Server server = serverApi.get(this.serverId);
        if (server == null) {
            throw new NotFoundException(String.format("failed to update meta data on server '%s': server not found", this.serverId));
        }
        for (String metadataKey : this.metadataKeysToDelete) {
            serverApi.deleteMetadata(this.serverId, metadataKey);
        }
        return null;
    }
}

