/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.openstack.requests;

import com.elastisys.scale.cloudadapers.api.NotFoundException;
import com.elastisys.scale.cloudadapters.commons.adapter.scalinggroup.ScalingGroupException;
import com.elastisys.scale.cloudadapters.openstack.requests.AbstractNovaRequest;
import com.elastisys.scale.cloudadapters.openstack.requests.ServerExistsRequest;
import com.elastisys.scale.cloudadapters.openstack.scalinggroup.OpenStackScalingGroupConfig;
import com.elastisys.scale.commons.net.retryable.Retryable;
import com.elastisys.scale.commons.net.retryable.Retryers;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.FloatingIP;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.extensions.FloatingIPApi;
import org.jclouds.openstack.nova.v2_0.features.ServerApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteServerRequest
extends AbstractNovaRequest<Void> {
    static final Logger LOG = LoggerFactory.getLogger(DeleteServerRequest.class);
    private final String victimId;

    public DeleteServerRequest(OpenStackScalingGroupConfig account, String victimId) {
        super(account);
        this.victimId = victimId;
    }

    @Override
    public Void doRequest(NovaApi api) throws NotFoundException {
        ServerApi serverApi = api.getServerApiForZone(this.getAccount().getRegion());
        Server victimServer = serverApi.get(this.victimId);
        if (victimServer == null) {
            throw new NotFoundException(String.format("a victim server with id '%s' could not be found in region %s", this.victimId, this.getAccount().getRegion()));
        }
        this.releaseFloatingIps(api, this.getAccount().getRegion(), victimServer);
        boolean wasDeleted = serverApi.delete(this.victimId);
        if (!wasDeleted) {
            throw new ScalingGroupException("failed to delete victim server " + this.victimId);
        }
        try {
            this.awaitTermination(victimServer.getId());
        }
        catch (Exception e) {
            throw new ScalingGroupException(String.format("timed out waiting for server %s to be terminated", e.getMessage()), e);
        }
        return null;
    }

    private void awaitTermination(String serverId) throws Exception {
        String taskName = String.format("termination-waiter{%s}", serverId);
        ServerExistsRequest serverExistsRequester = new ServerExistsRequest(this.getAccount(), serverId);
        int fixedDelay = 5;
        int maxRetries = 12;
        Retryable<Boolean> awaitTermination = Retryers.fixedDelayRetryer(taskName, serverExistsRequester, fixedDelay, TimeUnit.SECONDS, maxRetries, Predicates.equalTo(false));
        awaitTermination.call();
    }

    private void releaseFloatingIps(NovaApi api, String region, Server server) {
        LOG.debug("releasing any floating IP addresses associated with '{}'", (Object)server.getName());
        if (!api.getFloatingIPExtensionForZone(region).isPresent()) {
            LOG.debug("no floating IP API in region '{}', not attempting to release floating IPs.", (Object)region);
            return;
        }
        FloatingIPApi floatingIpApi = api.getFloatingIPExtensionForZone(region).get();
        ArrayList<FloatingIP> floatingIps = Lists.newArrayList(floatingIpApi.list());
        for (FloatingIP floatingIP : floatingIps) {
            if (!server.getId().equals(floatingIP.getInstanceId())) continue;
            LOG.debug("releasing floating IP {} from '{}'", (Object)floatingIP.getIp(), (Object)server.getName());
            floatingIpApi.removeFromServer(floatingIP.getIp(), server.getId());
            floatingIpApi.delete(floatingIP.getId());
        }
    }
}

