/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.openstack.requests;

import com.elastisys.scale.cloudadapers.api.NotFoundException;
import com.elastisys.scale.cloudadapters.openstack.requests.AbstractNovaRequest;
import com.elastisys.scale.cloudadapters.openstack.scalinggroup.OpenStackScalingGroupConfig;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.features.ServerApi;

public class GetServerRequest
extends AbstractNovaRequest<Server> {
    private String serverId;

    public GetServerRequest(OpenStackScalingGroupConfig account, String serverId) {
        super(account);
        this.serverId = serverId;
    }

    @Override
    public Server doRequest(NovaApi api) throws NotFoundException {
        ServerApi serverApi = api.getServerApiForZone(this.getAccount().getRegion());
        Server server = serverApi.get(this.serverId);
        if (server == null) {
            throw new NotFoundException(String.format("failed to retrieve server '%s' in region %s", this.serverId, this.getAccount().getRegion()));
        }
        return server;
    }
}

