/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.openstack.requests;

import com.elastisys.scale.cloudadapters.openstack.predicates.ServerPredicates;
import com.elastisys.scale.cloudadapters.openstack.requests.AbstractNovaRequest;
import com.elastisys.scale.cloudadapters.openstack.scalinggroup.OpenStackScalingGroupConfig;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.features.ServerApi;

public class ListServersWithTagRequest
extends AbstractNovaRequest<List<Server>> {
    private final String tag;
    private final String tagValue;

    public ListServersWithTagRequest(OpenStackScalingGroupConfig account, String tag, String tagValue) {
        super(account);
        this.tag = tag;
        this.tagValue = tagValue;
    }

    @Override
    public List<Server> doRequest(NovaApi api) {
        ArrayList<Server> response = Lists.newArrayList();
        ServerApi serverApi = api.getServerApiForZone(this.getAccount().getRegion());
        FluentIterable<Server> servers = serverApi.listInDetail().concat();
        response.addAll(Lists.newArrayList(Iterables.filter(servers, ServerPredicates.withTag(this.tag, this.tagValue))));
        return response;
    }
}

