/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.openstack.requests;

import com.elastisys.scale.cloudadapters.openstack.requests.AbstractNovaRequest;
import com.elastisys.scale.cloudadapters.openstack.scalinggroup.OpenStackScalingGroupConfig;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Flavor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListSizesRequest
extends AbstractNovaRequest<List<Flavor>> {
    static Logger LOG = LoggerFactory.getLogger(ListSizesRequest.class);

    public ListSizesRequest(OpenStackScalingGroupConfig account) {
        super(account);
    }

    @Override
    public List<Flavor> doRequest(NovaApi api) {
        ArrayList<Flavor> flavors = Lists.newArrayList();
        FluentIterable<Flavor> regionFlavors = api.getFlavorApiForZone(this.getAccount().getRegion()).listInDetail().concat();
        Iterables.addAll(flavors, regionFlavors);
        return flavors;
    }
}

