/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.openstack.requests;

import com.elastisys.scale.cloudadapers.api.NotFoundException;
import com.elastisys.scale.cloudadapters.openstack.requests.AbstractNovaRequest;
import com.elastisys.scale.cloudadapters.openstack.scalinggroup.OpenStackScalingGroupConfig;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.features.ServerApi;

public class UpdateServerMetadataRequest
extends AbstractNovaRequest<Void> {
    private final String serverId;
    private final Map<String, String> metadata;

    public UpdateServerMetadataRequest(OpenStackScalingGroupConfig account, String serverId, Map<String, String> metadata) {
        super(account);
        Preconditions.checkNotNull(serverId, "server id cannot be null");
        Preconditions.checkNotNull(metadata, "metadata map cannot be null");
        this.serverId = serverId;
        this.metadata = metadata;
    }

    @Override
    public Void doRequest(NovaApi api) throws NotFoundException {
        ServerApi serverApi = api.getServerApiForZone(this.getAccount().getRegion());
        Server server = serverApi.get(this.serverId);
        if (server == null) {
            throw new NotFoundException(String.format("failed to update meta data on server '%s': server not found", this.serverId));
        }
        HashMap<String, String> tags = new HashMap<String, String>(server.getMetadata());
        tags.putAll(this.metadata);
        serverApi.setMetadata(this.serverId, tags);
        return null;
    }
}

