/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.openstack.scalinggroup;

import com.elastisys.scale.cloudadapers.api.NotFoundException;
import com.elastisys.scale.cloudadapers.api.types.Machine;
import com.elastisys.scale.cloudadapers.api.types.ServiceState;
import com.elastisys.scale.cloudadapters.commons.adapter.BaseCloudAdapterConfig;
import com.elastisys.scale.cloudadapters.commons.adapter.scalinggroup.ScalingGroup;
import com.elastisys.scale.cloudadapters.commons.adapter.scalinggroup.ScalingGroupException;
import com.elastisys.scale.cloudadapters.commons.adapter.scalinggroup.StartMachinesException;
import com.elastisys.scale.cloudadapters.openstack.functions.ServerToMachine;
import com.elastisys.scale.cloudadapters.openstack.scalinggroup.OpenStackScalingGroupConfig;
import com.elastisys.scale.cloudadapters.openstack.scalinggroup.client.OpenstackClient;
import com.elastisys.scale.commons.json.JsonUtils;
import com.elastisys.scale.commons.json.schema.JsonValidator;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Atomics;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenStackScalingGroup
implements ScalingGroup {
    private static final JsonObject CONFIG_SCHEMA = JsonUtils.parseJsonResource("openstack-scaling-group-schema.json");
    static Logger LOG = LoggerFactory.getLogger(OpenStackScalingGroup.class);
    private final AtomicReference<OpenStackScalingGroupConfig> config = Atomics.newReference();
    private final AtomicReference<String> scalingGroupName = Atomics.newReference();
    private final OpenstackClient client;

    public OpenStackScalingGroup(OpenstackClient client) {
        this.client = client;
    }

    @Override
    public void configure(BaseCloudAdapterConfig configuration) throws ScalingGroupException {
        BaseCloudAdapterConfig.ScalingGroupConfig scalingGroupConfig = configuration.getScalingGroup();
        Preconditions.checkArgument(scalingGroupConfig != null, "missing scalingGroup config");
        try {
            JsonValidator.validate(CONFIG_SCHEMA, scalingGroupConfig.getConfig());
            OpenStackScalingGroupConfig config = JsonUtils.toObject(scalingGroupConfig.getConfig(), OpenStackScalingGroupConfig.class);
            config.validate();
            this.config.set(config);
            this.scalingGroupName.set(scalingGroupConfig.getName());
            this.client.configure(config);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf(e, ScalingGroupException.class);
            throw new ScalingGroupException(String.format("failed to apply configuration: %s", e.getMessage()), e);
        }
    }

    @Override
    public List<Machine> listMachines() throws ScalingGroupException {
        Preconditions.checkState(this.isConfigured(), "attempt to use unconfigured ScalingGroup");
        try {
            List<Server> servers = this.client.getServers("elastisys:scalingGroup", this.getScalingGroupName());
            return Lists.transform(servers, new ServerToMachine());
        }
        catch (Exception e) {
            throw new ScalingGroupException(String.format("failed to retrieve machines in scaling group \"%s\": %s", this.scalingGroupName, e.getMessage()), e);
        }
    }

    @Override
    public List<Machine> startMachines(int count, BaseCloudAdapterConfig.ScaleUpConfig scaleUpConfig) throws StartMachinesException {
        Preconditions.checkState(this.isConfigured(), "attempt to use unconfigured ScalingGroup");
        ArrayList<Machine> startedMachines = Lists.newArrayList();
        try {
            for (int i = 0; i < count; ++i) {
                ImmutableMap<String, String> tags = ImmutableMap.of("elastisys:scalingGroup", this.getScalingGroupName());
                Server newServer = this.client.launchServer(this.uniqueServerName(), scaleUpConfig, tags);
                startedMachines.add(ServerToMachine.convert(newServer));
                if (!this.config().isAssignFloatingIp().booleanValue()) continue;
                String serverId = newServer.getId();
                this.client.assignFloatingIp(serverId);
                startedMachines.set(i, ServerToMachine.convert(this.client.getServer(serverId)));
            }
        }
        catch (Exception e) {
            throw new StartMachinesException(count, startedMachines, e);
        }
        return startedMachines;
    }

    @Override
    public void terminateMachine(String machineId) throws ScalingGroupException {
        Preconditions.checkState(this.isConfigured(), "attempt to use unconfigured ScalingGroup");
        this.getMachineOrFail(machineId);
        try {
            this.client.terminateServer(machineId);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf(e, ScalingGroupException.class);
            String message = String.format("failed to terminate server \"%s\": %s", machineId, e.getMessage());
            throw new ScalingGroupException(message, e);
        }
    }

    @Override
    public void attachMachine(String machineId) throws NotFoundException, ScalingGroupException {
        Preconditions.checkState(this.isConfigured(), "attempt to use unconfigured ScalingGroup");
        ImmutableMap<String, String> tags = ImmutableMap.of("elastisys:scalingGroup", this.getScalingGroupName());
        try {
            this.client.tagServer(machineId, tags);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf(e, NotFoundException.class);
            Throwables.propagateIfInstanceOf(e, ScalingGroupException.class);
            String message = String.format("failed to attach server \"%s\": %s", machineId, e.getMessage());
            throw new ScalingGroupException(message, e);
        }
    }

    @Override
    public void detachMachine(String machineId) throws NotFoundException, ScalingGroupException {
        Preconditions.checkState(this.isConfigured(), "attempt to use unconfigured ScalingGroup");
        this.getMachineOrFail(machineId);
        try {
            List<String> tagKeys = Arrays.asList("elastisys:scalingGroup");
            this.client.untagServer(machineId, tagKeys);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf(e, ScalingGroupException.class);
            String message = String.format("failed to detach server \"%s\": %s", machineId, e.getMessage());
            throw new ScalingGroupException(message, e);
        }
    }

    @Override
    public void setServiceState(String machineId, ServiceState serviceState) throws NotFoundException {
        Preconditions.checkState(this.isConfigured(), "attempt to use unconfigured ScalingGroup");
        this.getMachineOrFail(machineId);
        try {
            LOG.debug("service state {} reported for {}", (Object)serviceState.name(), (Object)machineId);
            ImmutableMap<String, String> tags = ImmutableMap.of("elastisys:serviceState", serviceState.name());
            this.client.tagServer(machineId, tags);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf(e, ScalingGroupException.class);
            String message = String.format("failed to tag service state on server \"%s\": %s", machineId, e.getMessage());
            throw new ScalingGroupException(message, e);
        }
    }

    @Override
    public String getScalingGroupName() {
        Preconditions.checkState(this.isConfigured(), "attempt to use unconfigured ScalingGroup");
        return this.scalingGroupName.get();
    }

    private Machine getMachineOrFail(String machineId) throws NotFoundException {
        List<Machine> machines = this.listMachines();
        for (Machine machine : machines) {
            if (!machine.getId().equals(machineId)) continue;
            return machine;
        }
        throw new NotFoundException(String.format("no machine with id '%s' found in scaling group", machineId));
    }

    private String uniqueServerName() {
        String prefix = this.getScalingGroupName();
        String suffix = UUID.randomUUID().toString();
        return String.format("%s-%s", prefix, suffix);
    }

    boolean isConfigured() {
        return this.config() != null;
    }

    OpenStackScalingGroupConfig config() {
        return this.config.get();
    }
}

