/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.openstack.scalinggroup;

import com.elastisys.scale.cloudadapters.commons.adapter.scalinggroup.ScalingGroupException;
import com.elastisys.scale.commons.json.JsonUtils;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class OpenStackScalingGroupConfig {
    private final String keystoneEndpoint;
    private final String region;
    private final String tenantName;
    private final String userName;
    private final String password;
    private final Boolean assignFloatingIp;

    public OpenStackScalingGroupConfig(String keystoneEndpoint, String region, String tenantName, String userName, String password) {
        this(keystoneEndpoint, region, tenantName, userName, password, true);
    }

    public OpenStackScalingGroupConfig(String keystoneEndpoint, String region, String tenantName, String userName, String password, Boolean assignFloatingIp) {
        this.keystoneEndpoint = keystoneEndpoint;
        this.region = region;
        this.userName = userName;
        this.password = password;
        this.tenantName = tenantName;
        this.assignFloatingIp = assignFloatingIp;
    }

    public String getKeystoneEndpoint() {
        return this.keystoneEndpoint;
    }

    public String getRegion() {
        return this.region;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public Boolean isAssignFloatingIp() {
        return Optional.fromNullable(this.assignFloatingIp).or(true);
    }

    public void validate() throws ScalingGroupException {
        try {
            Preconditions.checkNotNull(this.keystoneEndpoint, "missing keystoneEndpoint");
            Preconditions.checkNotNull(this.region, "missing region");
            Preconditions.checkNotNull(this.tenantName, "missing tenantName");
            Preconditions.checkNotNull(this.userName, "missing userName");
            Preconditions.checkNotNull(this.password, "missing password");
        }
        catch (Exception e) {
            throw new ScalingGroupException(String.format("failed to validate cloud client configuration: %s", e.getMessage()), e);
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.keystoneEndpoint, this.region, this.tenantName, this.userName, this.password, this.isAssignFloatingIp());
    }

    public boolean equals(Object obj) {
        if (obj instanceof OpenStackScalingGroupConfig) {
            OpenStackScalingGroupConfig that = (OpenStackScalingGroupConfig)obj;
            return Objects.equal(this.keystoneEndpoint, that.keystoneEndpoint) && Objects.equal(this.region, that.region) && Objects.equal(this.tenantName, that.tenantName) && Objects.equal(this.userName, that.userName) && Objects.equal(this.password, that.password) && Objects.equal(this.isAssignFloatingIp(), that.isAssignFloatingIp());
        }
        return false;
    }

    public String toString() {
        return JsonUtils.toString(JsonUtils.toJson(this));
    }
}

