/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.openstack.scalinggroup.client;

import com.elastisys.scale.cloudadapers.api.NotFoundException;
import com.elastisys.scale.cloudadapters.commons.adapter.BaseCloudAdapterConfig;
import com.elastisys.scale.cloudadapters.openstack.requests.AssignFloatingIpRequest;
import com.elastisys.scale.cloudadapters.openstack.requests.CreateServerRequest;
import com.elastisys.scale.cloudadapters.openstack.requests.DeleteServerMetadataRequest;
import com.elastisys.scale.cloudadapters.openstack.requests.DeleteServerRequest;
import com.elastisys.scale.cloudadapters.openstack.requests.GetServerRequest;
import com.elastisys.scale.cloudadapters.openstack.requests.ListServersWithTagRequest;
import com.elastisys.scale.cloudadapters.openstack.requests.UpdateServerMetadataRequest;
import com.elastisys.scale.cloudadapters.openstack.scalinggroup.OpenStackScalingGroupConfig;
import com.elastisys.scale.cloudadapters.openstack.scalinggroup.client.OpenstackClient;
import com.elastisys.scale.cloudadapters.openstack.utils.jclouds.ScriptUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Atomics;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.scriptbuilder.domain.OsFamily;

public class StandardOpenstackClient
implements OpenstackClient {
    private final AtomicReference<OpenStackScalingGroupConfig> config = Atomics.newReference();

    @Override
    public void configure(OpenStackScalingGroupConfig configuration) {
        Preconditions.checkArgument(configuration != null, "null configuration");
        this.config.set(configuration);
    }

    @Override
    public List<Server> getServers(String tag, String tagValue) {
        Preconditions.checkArgument(this.isConfigured(), "can't use client before it's configured");
        return (List)new ListServersWithTagRequest(this.config(), tag, tagValue).call();
    }

    @Override
    public Server getServer(String serverId) throws NotFoundException {
        Preconditions.checkArgument(this.isConfigured(), "can't use client before it's configured");
        return (Server)new GetServerRequest(this.config(), serverId).call();
    }

    @Override
    public Server launchServer(String serverName, BaseCloudAdapterConfig.ScaleUpConfig provisioningDetails, Map<String, String> tags) {
        Preconditions.checkArgument(this.isConfigured(), "can't use client before it's configured");
        String userData = ScriptUtils.renderScript(Joiner.on("\n").join(provisioningDetails.getBootScript()), OsFamily.UNIX);
        CreateServerRequest request = new CreateServerRequest(this.config(), serverName, provisioningDetails.getSize(), provisioningDetails.getImage(), provisioningDetails.getKeyPair(), provisioningDetails.getSecurityGroups(), Optional.of(userData), tags);
        return (Server)request.call();
    }

    @Override
    public String assignFloatingIp(String serverId) throws NotFoundException {
        Server server = this.getServer(serverId);
        return (String)new AssignFloatingIpRequest(this.config(), server).call();
    }

    @Override
    public void terminateServer(String serverId) throws NotFoundException {
        Preconditions.checkArgument(this.isConfigured(), "can't use client before it's configured");
        new DeleteServerRequest(this.config(), serverId).call();
    }

    @Override
    public void tagServer(String serverId, Map<String, String> tags) {
        Preconditions.checkArgument(this.isConfigured(), "can't use client before it's configured");
        new UpdateServerMetadataRequest(this.config(), serverId, tags).call();
    }

    @Override
    public void untagServer(String serverId, List<String> tagKeys) {
        Preconditions.checkArgument(this.isConfigured(), "can't use client before it's configured");
        new DeleteServerMetadataRequest(this.config(), serverId, tagKeys).call();
    }

    private boolean isConfigured() {
        return this.config() != null;
    }

    private OpenStackScalingGroupConfig config() {
        return this.config.get();
    }
}

