/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.cloudadapters.openstack.utils;

import com.elastisys.scale.cloudadapters.openstack.scalinggroup.OpenStackScalingGroupConfig;
import com.google.common.collect.ImmutableSet;
import java.util.Properties;
import org.jclouds.ContextBuilder;
import org.jclouds.logging.slf4j.config.SLF4JLoggingModule;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.NovaApiMetadata;

public class OpenstackApiUtils {
    public static NovaApi getNativeApi(OpenStackScalingGroupConfig account) {
        Properties overrides = OpenstackApiUtils.buildOverrideProperties();
        String identity = account.getTenantName() + ":" + account.getUserName();
        String password = account.getPassword();
        ImmutableSet<SLF4JLoggingModule> modules = ImmutableSet.of(new SLF4JLoggingModule());
        return ContextBuilder.newBuilder(new NovaApiMetadata()).endpoint(account.getKeystoneEndpoint()).modules(modules).credentials(identity, password).overrides(overrides).buildApi(NovaApi.class);
    }

    private static Properties buildOverrideProperties() {
        Properties properties = new Properties();
        properties.setProperty("jclouds.trust-all-certs", "true");
        properties.setProperty("jclouds.keystone.credential-type", "passwordCredentials");
        properties.setProperty("jclouds.compute.timeout.port-open", "20000");
        return properties;
    }
}

