/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.json;

import com.elastisys.scale.commons.json.typeadapters.GsonDateTimeDeserializer;
import com.elastisys.scale.commons.json.typeadapters.GsonDateTimeSerializer;
import com.elastisys.scale.commons.json.typeadapters.ImmutableListDeserializer;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import org.joda.time.DateTime;

public class JsonUtils {
    private JsonUtils() {
        throw new UnsupportedOperationException(JsonUtils.class.getName() + " is not instantiable.");
    }

    public static JsonObject parseJsonString(String jsonString) throws RuntimeException {
        Preconditions.checkNotNull(jsonString, "null argument not allowed");
        return new JsonParser().parse(jsonString).getAsJsonObject();
    }

    public static JsonObject parseJsonResource(String resourceName) throws RuntimeException {
        Preconditions.checkNotNull(resourceName, "null resource not allowed");
        URL resource = Resources.getResource(resourceName);
        try {
            return JsonUtils.parseJsonString(Resources.toString(resource, Charsets.UTF_8));
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    public static JsonObject parseJsonFile(File jsonFile) throws RuntimeException {
        Preconditions.checkNotNull(jsonFile, "null file not allowed");
        try {
            return JsonUtils.parseJsonString(Files.toString(jsonFile, Charsets.UTF_8));
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    public static JsonElement toJson(Object object) {
        return JsonUtils.toJson(object, false);
    }

    public static JsonElement toJson(Object object, boolean serializeNullFields) {
        Preconditions.checkNotNull(object, "null object not allowed");
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter((Type)((Object)DateTime.class), new GsonDateTimeSerializer());
        if (serializeNullFields) {
            gsonBuilder.serializeNulls();
        }
        Gson gson = gsonBuilder.create();
        return gson.toJsonTree(object);
    }

    public static String toPrettyString(JsonElement jsonElement) {
        Preconditions.checkNotNull(jsonElement, "null jsonElement not allowed");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson(jsonElement);
    }

    public static String toString(JsonElement jsonElement) {
        Preconditions.checkNotNull(jsonElement, "null jsonElement not allowed");
        Gson gson = new GsonBuilder().create();
        return gson.toJson(jsonElement);
    }

    public static <T> T toObject(JsonElement jsonObject, Class<T> type) {
        Preconditions.checkNotNull(jsonObject, "null jsonObject not allowed");
        Preconditions.checkNotNull(type, "null type not allowed");
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)DateTime.class), new GsonDateTimeDeserializer()).registerTypeAdapter((Type)((Object)ImmutableList.class), new ImmutableListDeserializer()).create();
        return type.cast(gson.fromJson(jsonObject, type));
    }
}

