/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.json.schema;

import com.elastisys.scale.commons.json.JsonUtils;
import com.elastisys.scale.commons.json.schema.JsonSchemaValidationException;
import com.elastisys.scale.commons.json.schema.JsonValidatorException;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.google.gson.JsonObject;
import java.io.IOException;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class JsonValidator {
    private static final String TINY_JSON_VALIDATOR_VERSION = "1.0.11";
    private static final String TINY_JSON_VALIDATOR_PATH = String.format("jsonschema/tv4-%s.min.js", "1.0.11");

    public static void validate(JsonObject jsonSchema, JsonObject schemaInstance) throws JsonValidatorException {
        JsonValidator.validate(JsonUtils.toString(jsonSchema), JsonUtils.toString(schemaInstance));
    }

    public static void validate(String jsonSchema, String schemaInstance) throws JsonValidatorException {
        String tinyJsonV4Validator = JsonValidator.loadTv4Lib();
        ScriptEngineManager factory = new ScriptEngineManager();
        ScriptEngine engine = factory.getEngineByName("JavaScript");
        try {
            engine.eval(tinyJsonV4Validator);
            engine.eval("var schema = " + jsonSchema);
            engine.eval("var instance = " + schemaInstance);
            boolean isValid = (Boolean)engine.eval("tv4.validate(instance, schema)");
            if (!isValid) {
                String message = (String)engine.eval("tv4.error.message");
                String dataPath = (String)engine.eval("tv4.error.dataPath");
                String schemaPath = (String)engine.eval("tv4.error.schemaPath");
                throw new JsonSchemaValidationException(message, schemaPath, dataPath);
            }
        }
        catch (ScriptException e) {
            throw new JsonValidatorException("failed to validate json document against json schema: " + e.getMessage(), e);
        }
    }

    private static String loadTv4Lib() throws RuntimeException {
        try {
            return Resources.toString(Resources.getResource(TINY_JSON_VALIDATOR_PATH), Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to load tv4 (tiny json validator) JavaScript library: " + e.getMessage(), e);
        }
    }
}

