/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.net.host;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;

public class HostUtils {
    public static Collection<InetAddress> hostIpv4Addresses() throws RuntimeException {
        return HostUtils.hostIpv4Addresses(false);
    }

    public static Collection<InetAddress> hostIpv4Addresses(boolean includeLoopback) throws RuntimeException {
        LinkedList<InetAddress> ipAddresses = Lists.newLinkedList();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces == null) {
                return ipAddresses;
            }
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                if (networkInterface.isLoopback() && !includeLoopback) continue;
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (!Inet4Address.class.isInstance(inetAddress)) continue;
                    ipAddresses.add(inetAddress);
                }
            }
        }
        catch (SocketException e) {
            Throwables.propagate(e);
        }
        return ipAddresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Integer> findFreePorts(int numPorts) throws RuntimeException {
        ArrayList<Integer> freePorts = Lists.newArrayListWithCapacity(numPorts);
        ArrayList<ServerSocket> freePortSockets = Lists.newArrayList();
        try {
            for (int i = 0; i < numPorts; ++i) {
                try {
                    ServerSocket serverSocket = new ServerSocket(0);
                    freePortSockets.add(serverSocket);
                    freePorts.add(serverSocket.getLocalPort());
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException("failed to find free ports: " + e.getMessage(), e);
                }
            }
        }
        finally {
            for (ServerSocket freePortSocket : freePortSockets) {
                try {
                    freePortSocket.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("failed to close probed port: " + e.getMessage(), e);
                }
            }
        }
        return freePorts;
    }
}

