/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.net.http;

import com.elastisys.scale.commons.net.http.HttpRequestResponse;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.KeyStore;
import java.security.Security;
import java.util.concurrent.Callable;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class HttpGetRequester
implements Callable<HttpRequestResponse> {
    private static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 10000;
    private final String url;
    private final RequestConfig requestConfig;

    public HttpGetRequester(String url) {
        this(url, HttpGetRequester.defaultRequestConfig());
    }

    public HttpGetRequester(String url, RequestConfig requestConfig) {
        Preconditions.checkNotNull(url, "URL cannot be null");
        Preconditions.checkNotNull(requestConfig, "Request configuration cannot be null");
        this.url = url;
        this.requestConfig = requestConfig;
        this.limitDnsCacheTtl(30);
    }

    private static RequestConfig defaultRequestConfig() {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(5000).build();
        return requestConfig;
    }

    private void limitDnsCacheTtl(int ttlInSeconds) {
        Security.setProperty("networkaddress.cache.ttl", "" + ttlInSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpRequestResponse call() throws Exception {
        CloseableHttpClient httpclient = this.prepareClient();
        CloseableHttpResponse response = null;
        try {
            response = this.doGet(httpclient, this.url);
            HttpRequestResponse httpRequestResponse = this.toHttpGetResponse(response);
            return httpRequestResponse;
        }
        finally {
            if (response != null) {
                response.close();
            }
            httpclient.close();
        }
    }

    private CloseableHttpClient prepareClient() throws Exception {
        AllowAllHostnameVerifier hostnameVerifier = new AllowAllHostnameVerifier();
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(trustStore, new TrustSelfSignedStrategy()).build();
        CloseableHttpClient httpclient = HttpClients.custom().setDefaultRequestConfig(this.requestConfig).setSslcontext(sslContext).setHostnameVerifier(hostnameVerifier).build();
        return httpclient;
    }

    private HttpRequestResponse toHttpGetResponse(HttpResponse response) throws IOException {
        return new HttpRequestResponse(response);
    }

    private CloseableHttpResponse doGet(CloseableHttpClient httpclient, String url) throws ClientProtocolException, IOException {
        HttpGet httpget = new HttpGet(url);
        CloseableHttpResponse response = httpclient.execute(httpget);
        return response;
    }
}

