/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.net.http;

import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

public class HttpRequestResponse {
    private static final Pattern CHARSET_PATTERN = Pattern.compile(".*charset=([A-Za-z0-9\\-]+).*");
    private final int statusCode;
    private final Collection<Header> headers;
    private final String responseBody;

    public HttpRequestResponse(HttpResponse httpResponse) throws IOException {
        this(httpResponse, Charsets.UTF_8);
    }

    public HttpRequestResponse(HttpResponse httpResponse, Charset fallbackCharset) throws IOException {
        this.statusCode = httpResponse.getStatusLine().getStatusCode();
        this.headers = Lists.newArrayList(httpResponse.getAllHeaders());
        Charset responseCharset = this.determineCharset(httpResponse);
        Charset charset = responseCharset == null ? fallbackCharset : responseCharset;
        this.responseBody = EntityUtils.toString(httpResponse.getEntity(), charset);
    }

    private Charset determineCharset(HttpResponse httpResponse) {
        Matcher matcher;
        Header contentType;
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null && (contentType = entity.getContentType()) != null && (matcher = CHARSET_PATTERN.matcher(contentType.getValue())).matches()) {
            String charset = matcher.group(1);
            try {
                return Charset.forName(charset);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Collection<Header> getHeaders() {
        return this.headers;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("statusCode", this.statusCode).add("headers", this.headers).toString();
    }

    public static Predicate<HttpRequestResponse> isOkResponse() {
        return new Predicate<HttpRequestResponse>(){

            @Override
            public boolean apply(HttpRequestResponse response) {
                return Range.closed(200, 299).contains(response.getStatusCode());
            }
        };
    }
}

