/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.net.http.client;

import com.elastisys.scale.commons.net.http.HttpRequestResponse;
import com.elastisys.scale.commons.net.ssl.BasicCredentials;
import com.elastisys.scale.commons.net.ssl.CertificateCredentials;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Range;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatedHttpClient {
    private static Logger LOG = LoggerFactory.getLogger(AuthenticatedHttpClient.class);
    private static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 10000;
    private final Logger logger;
    private final Optional<BasicCredentials> basicCredentials;
    private final Optional<CertificateCredentials> certificateCredentials;
    private final int connectTimeout;
    private final int socketTimeout;

    public AuthenticatedHttpClient() {
        this(LOG, Optional.absent(), Optional.absent(), 10000, 10000);
    }

    public AuthenticatedHttpClient(Optional<BasicCredentials> basicCredentials, Optional<CertificateCredentials> certificateCredentials) {
        this(LOG, basicCredentials, certificateCredentials, 10000, 10000);
    }

    public AuthenticatedHttpClient(Logger logger, Optional<BasicCredentials> basicCredentials, Optional<CertificateCredentials> certificateCredentials, int connectTimeout, int socketTimeout) {
        Preconditions.checkNotNull(logger, "null logger provided");
        this.logger = logger;
        this.basicCredentials = basicCredentials;
        this.certificateCredentials = certificateCredentials;
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
    }

    private CloseableHttpClient prepareAuthenticatingClient() throws Exception {
        AllowAllHostnameVerifier hostnameVerifier = new AllowAllHostnameVerifier();
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial(trustStore, new TrustSelfSignedStrategy());
        if (this.certificateCredentials.isPresent()) {
            CertificateCredentials certCredentials = this.certificateCredentials.get();
            String keystorePath = certCredentials.getKeystorePath();
            String keystorePassword = certCredentials.getKeystorePassword();
            String keyPassword = certCredentials.getKeyPassword().or(keystorePassword);
            this.logger.debug("using client-side certificate from keystore '{}'", (Object)keystorePath);
            KeyStore keyStore = KeyStore.getInstance(certCredentials.getKeystoreType().name());
            keyStore.load(new FileInputStream(keystorePath), keystorePassword.toCharArray());
            sslContextBuilder.loadKeyMaterial(keyStore, keyPassword.toCharArray());
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        Optional<BasicCredentials> basicCredentials = this.basicCredentials;
        if (basicCredentials.isPresent()) {
            String username = basicCredentials.get().getUsername();
            String password = basicCredentials.get().getPassword();
            this.logger.debug("passing Basic authentication credentials for username '{}'", (Object)username);
            credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(username, password));
        }
        CloseableHttpClient httpclient = HttpClients.custom().setRedirectStrategy(new LaxRedirectStrategy()).setDefaultCredentialsProvider(credentialsProvider).setSslcontext(sslContextBuilder.build()).setHostnameVerifier(hostnameVerifier).build();
        return httpclient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpRequestResponse execute(HttpRequestBase request) throws HttpResponseException, IOException {
        CloseableHttpClient client;
        try {
            client = this.prepareAuthenticatingClient();
        }
        catch (Exception e) {
            throw new IOException(String.format("failed to prepare http client for request (%s): %s", request, e.getMessage()), e);
        }
        RequestConfig requestConfig = RequestConfig.copy(RequestConfig.DEFAULT).setSocketTimeout(this.socketTimeout).setConnectTimeout(this.connectTimeout).build();
        request.setConfig(requestConfig);
        try {
            CloseableHttpResponse httpResponse = null;
            try {
                this.logger.info(String.format("sending request (%s)", request));
                httpResponse = client.execute(request);
            }
            catch (Exception e) {
                Throwables.propagateIfInstanceOf(e, IOException.class);
                throw new IOException(String.format("failed to send request (%s): %s", request, e.getMessage()), e);
            }
            HttpRequestResponse response = new HttpRequestResponse(httpResponse);
            int responseCode = response.getStatusCode();
            String responseBody = response.getResponseBody();
            if (!Range.closed(200, 299).contains(responseCode)) {
                throw new HttpResponseException(responseCode, String.format("error response received from remote endpoint on request (%s): %s: %s", request, responseCode, responseBody));
            }
            HttpRequestResponse httpRequestResponse = response;
            return httpRequestResponse;
        }
        finally {
            client.close();
        }
    }
}

