/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.net.retryable;

import com.elastisys.scale.commons.net.retryable.DelayStrategy;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.TimeUnit;

public class DelayStrategies {
    public static DelayStrategy noDelay() {
        return new DelayStrategy(){

            @Override
            public void introduceDelay(int failedAttempts, long elapsedTimeMillis) {
            }
        };
    }

    public static DelayStrategy fixed(final int duration, final TimeUnit unit) {
        return new DelayStrategy(){

            @Override
            public void introduceDelay(int failedAttempts, long elapsedTimeMillis) {
                Uninterruptibles.sleepUninterruptibly(duration, unit);
            }
        };
    }

    public static DelayStrategy exponentialBackoff(final int initialDelay, final TimeUnit unit) {
        return new DelayStrategy(){

            @Override
            public void introduceDelay(int failedAttempts, long elapsedTimeMillis) {
                int sleepTime = initialDelay * (1 << failedAttempts - 1);
                Uninterruptibles.sleepUninterruptibly(sleepTime, unit);
            }
        };
    }
}

