/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.net.retryable;

import com.elastisys.scale.commons.net.retryable.DelayStrategies;
import com.elastisys.scale.commons.net.retryable.DelayStrategy;
import com.elastisys.scale.commons.net.retryable.GaveUpException;
import com.elastisys.scale.commons.net.retryable.StopStrategies;
import com.elastisys.scale.commons.net.retryable.StopStrategy;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Retryable<R>
implements Callable<R> {
    private static final Logger LOG = LoggerFactory.getLogger(Retryable.class);
    private static final int MAX_LOGGED_RESULT_STRING = 200;
    private final Callable<R> task;
    private String name;
    private Predicate<R> successfulResponse;
    private StopStrategy stopStrategy;
    private DelayStrategy delayStrategy;
    private Set<Class<? extends Exception>> suppressedErrors;
    private int attempts;
    private Stopwatch timer;

    public Retryable(Callable<R> task) {
        this.task = task;
        this.name = task.getClass().getSimpleName();
        this.successfulResponse = Predicates.alwaysTrue();
        this.stopStrategy = StopStrategies.never();
        this.delayStrategy = DelayStrategies.noDelay();
        this.suppressedErrors = Sets.newHashSet();
    }

    public Retryable<R> name(String taskName) {
        this.name = taskName;
        return this;
    }

    public Retryable<R> retryUntilResponse(Predicate<R> successfulResponse) {
        this.successfulResponse = successfulResponse;
        return this;
    }

    public Retryable<R> retryOnError(Class<? extends Exception> exception) {
        this.suppressedErrors.add(exception);
        return this;
    }

    public Retryable<R> retryOnException() {
        return this.retryOnError(Exception.class);
    }

    public Retryable<R> retryOnRuntimeException() {
        return this.retryOnError(RuntimeException.class);
    }

    public Retryable<R> stop(StopStrategy stopStrategy) {
        this.stopStrategy = stopStrategy;
        return this;
    }

    public Retryable<R> delay(DelayStrategy delayStrategy) {
        this.delayStrategy = delayStrategy;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R call() throws Exception {
        this.attempts = 0;
        this.timer = Stopwatch.createStarted();
        Exception lastResult = null;
        try {
            while (true) {
                block11: {
                    R r;
                    try {
                        ++this.attempts;
                        R response = this.task.call();
                        lastResult = response;
                        if (!this.successfulResponse.apply(response)) break block11;
                        r = response;
                    }
                    catch (Exception e) {
                        lastResult = e;
                        this.throwIfNotSuppressed(e);
                        break block11;
                    }
                    finally {
                        this.logResult(this.attempts, lastResult);
                    }
                    return r;
                }
                long elapsedTimeMillis = this.timer.elapsed(TimeUnit.MILLISECONDS);
                if (this.stopStrategy.giveUp(this.attempts, elapsedTimeMillis)) {
                    this.giveUp(this.attempts, elapsedTimeMillis, lastResult);
                }
                this.delayStrategy.introduceDelay(this.attempts, elapsedTimeMillis);
            }
        }
        finally {
            this.timer.stop();
        }
    }

    private void giveUp(int attempts, long elapsedTimeMillis, Object lastResult) throws GaveUpException {
        String message = String.format("gave up waiting for '%s' after %d attempt(s) (%d ms): result from last attempt: %s", this.name, attempts, elapsedTimeMillis, this.asString(lastResult));
        if (Throwable.class.isAssignableFrom(lastResult.getClass())) {
            throw new GaveUpException(message, (Throwable)Throwable.class.cast(lastResult));
        }
        throw new GaveUpException(message);
    }

    private void logResult(int attempts, Object lastResult) {
        if (LOG.isDebugEnabled()) {
            String resultString = this.asString(lastResult);
            if (resultString.length() > 200) {
                resultString = resultString.substring(0, 200) + " ... (truncated)";
            }
            LOG.debug("{}: attempt {}: '{}'", this.name, attempts, resultString);
        }
    }

    private String asString(Object result) {
        if (Throwable.class.isAssignableFrom(result.getClass())) {
            return ((Throwable)Throwable.class.cast(result)).getMessage();
        }
        return result.toString();
    }

    int getAttempts() {
        return this.attempts;
    }

    Stopwatch getTimer() {
        return this.timer;
    }

    private void throwIfNotSuppressed(Exception caughtError) throws Exception {
        for (Class<? extends Exception> suppressedError : this.suppressedErrors) {
            if (!suppressedError.isAssignableFrom(caughtError.getClass())) continue;
            return;
        }
        throw caughtError;
    }
}

