/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.net.retryable;

import com.elastisys.scale.commons.net.retryable.DelayStrategies;
import com.elastisys.scale.commons.net.retryable.Retryable;
import com.elastisys.scale.commons.net.retryable.StopStrategies;
import com.google.common.base.Predicate;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class Retryers {
    public static <R> Retryable<R> fixedDelayRetryer(String name, Callable<R> callable, int fixedDelay, TimeUnit unit, int maxAttempts) {
        return new Retryable<R>(callable).name(name).delay(DelayStrategies.fixed(fixedDelay, unit)).stop(StopStrategies.afterAttempts(maxAttempts)).retryOnException();
    }

    public static <R> Retryable<R> fixedDelayRetryer(String name, Callable<R> callable, int fixedDelay, TimeUnit unit, int maxAttempts, Predicate<R> responsePredicate) {
        return new Retryable<R>(callable).name(name).delay(DelayStrategies.fixed(fixedDelay, unit)).stop(StopStrategies.afterAttempts(maxAttempts)).retryOnException().retryUntilResponse(responsePredicate);
    }

    public static <R> Retryable<R> exponentialBackoffRetryer(String name, Callable<R> callable, int initialDelay, TimeUnit unit, int maxAttempts) {
        return new Retryable<R>(callable).name(name).delay(DelayStrategies.exponentialBackoff(initialDelay, unit)).stop(StopStrategies.afterAttempts(maxAttempts)).retryOnException();
    }

    public static <R> Retryable<R> exponentialBackoffRetryer(String name, Callable<R> callable, int initialDelay, TimeUnit unit, int maxAttempts, Predicate<R> responsePredicate) {
        return new Retryable<R>(callable).name(name).delay(DelayStrategies.exponentialBackoff(initialDelay, unit)).stop(StopStrategies.afterAttempts(maxAttempts)).retryOnException().retryUntilResponse(responsePredicate);
    }
}

