/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.net.retryable;

import com.elastisys.scale.commons.net.retryable.StopStrategy;
import java.util.concurrent.TimeUnit;

public class StopStrategies {
    public static StopStrategy never() {
        return new StopStrategy(){

            @Override
            public boolean giveUp(int failedAttempts, long elapsedTimeInMillis) {
                return false;
            }
        };
    }

    public static StopStrategy afterTime(final int maxElapsedTime, final TimeUnit unit) {
        return new StopStrategy(){

            @Override
            public boolean giveUp(int failedAttempts, long elapsedTimeInMillis) {
                long maxInMillis = TimeUnit.MILLISECONDS.convert(maxElapsedTime, unit);
                return elapsedTimeInMillis > maxInMillis;
            }
        };
    }

    public static StopStrategy afterAttempts(final int maxAttempts) {
        return new StopStrategy(){

            @Override
            public boolean giveUp(int failedAttempts, long elapsedTimeInMillis) {
                return failedAttempts >= maxAttempts;
            }
        };
    }
}

