/*
 * Decompiled with CFR 0.152.
 */
package com.elastisys.scale.commons.net.smtp;

import com.elastisys.scale.commons.util.time.UtcTime;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.joda.time.DateTime;

public class SmtpMessage {
    private final List<InternetAddress> to;
    private final InternetAddress from;
    private final String subject;
    private final String content;
    private final DateTime dateSent;

    public SmtpMessage(List<String> recipients, String sender, String subject, String content, DateTime dateSent) throws IllegalArgumentException {
        Preconditions.checkArgument(recipients != null, "recipients cannot be null");
        Preconditions.checkArgument(!recipients.isEmpty(), "empty list of recipients");
        Preconditions.checkArgument(sender != null, "missing sender address");
        try {
            this.to = Lists.newArrayList();
            for (String recipient : recipients) {
                Preconditions.checkArgument(recipient != null, "recipient address cannot be null");
                this.to.add(new InternetAddress(recipient, true));
            }
            this.from = new InternetAddress(sender, true);
        }
        catch (AddressException e) {
            throw new IllegalArgumentException("illegal email address(es) given: " + e.getMessage(), e);
        }
        this.subject = subject;
        this.content = content;
        this.dateSent = Optional.fromNullable(dateSent).or(UtcTime.now());
        this.validate();
    }

    public void validate() throws IllegalArgumentException {
        Preconditions.checkArgument(!this.to.isEmpty(), "empty list of recipients");
        Preconditions.checkArgument(this.from != null, "missing sender address");
        Preconditions.checkArgument(this.content != null, "content cannot be null");
    }

    public List<InternetAddress> getTo() {
        return this.to;
    }

    public InternetAddress getFrom() {
        return this.from;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getContent() {
        return this.content;
    }

    public DateTime getDateSent() {
        return this.dateSent;
    }

    public int hashCode() {
        return Objects.hashCode(this.to, this.from, this.subject, this.content, this.dateSent);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SmtpMessage) {
            SmtpMessage that = (SmtpMessage)obj;
            return Objects.equal(this.to, that.to) && Objects.equal(this.from, that.from) && Objects.equal(this.subject, that.subject) && Objects.equal(this.content, that.content) && Objects.equal(this.dateSent, that.dateSent);
        }
        return super.equals(obj);
    }
}

